/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import io.github.Memoires.trmysticism.entity.skill.ShadowSoulEntity;
import io.github.Memoires.trmysticism.entity.skill.ShadowSubordinateEntity;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class VainglorySkill
extends Skill {
    private final Map<UUID, ItemStack> shadowStorageBackup = new HashMap<UUID, ItemStack>();
    private final Map<UUID, List<ManasSkillInstance>> temporarySkillsMap = new HashMap<UUID, List<ManasSkillInstance>>();
    protected static final UUID SHADOW_MERGE = UUID.fromString("59de7343-64d7-4acf-a988-8ea372045463");

    public VainglorySkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/vainglory.png");
    }

    public double getObtainingEpCost() {
        return 100000.0;
    }

    public int modes() {
        return 3;
    }

    public int nextMode(LivingEntity entity, TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 3 : instance.getMode() - 1;
        }
        return instance.getMode() == 3 ? 1 : instance.getMode() + 1;
    }

    public int getMaxMastery() {
        return 1500;
    }

    public boolean meetEPRequirement(Player entity, double newEP) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)entity);
        return storage.getSkill((ManasSkill)UniqueSkills.PLUNDERER.get()).map(instance -> instance.isMastered((LivingEntity)entity)).orElse(false) != false && storage.getSkill((ManasSkill)UniqueSkills.PLUNDERER.get()).map(instance -> instance.isMastered((LivingEntity)entity)).orElse(false) != false;
    }

    public boolean canBeToggled(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.vainglory.shadow_warrior");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.vainglory.shadow_storage");
            case 3 -> Component.m_237115_((String)"trmysticism.skill.mode.vainglory.shadow_merge");
            default -> Component.m_237119_();
        };
    }

    private void setStats(LivingEntity originalEntity, ShadowSubordinateEntity shadowSubordinate) {
        shadowSubordinate.m_21153_(originalEntity.m_21233_());
        shadowSubordinate.m_7910_(originalEntity.m_6113_());
        TensuraEPCapability.setSpiritualHealth((LivingEntity)shadowSubordinate, (double)TensuraEPCapability.getSpiritualHealth((LivingEntity)originalEntity));
        TensuraEPCapability.setLivingEP((LivingEntity)shadowSubordinate, (double)TensuraEPCapability.getEP((LivingEntity)originalEntity));
    }

    public boolean canTick(ManasSkillInstance instance, LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void onTick(ManasSkillInstance instance, LivingEntity entity) {
        long timeOfDay = entity.f_19853_.m_46468_() % 24000L;
        List list = entity.m_9236_().m_6443_(ShadowSubordinateEntity.class, entity.m_20191_().m_82400_(30.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && living.m_7307_((Entity)entity));
        if (!list.isEmpty()) {
            for (ShadowSubordinateEntity target : list) {
                if (SkillHelper.isSubordinate((LivingEntity)target, (LivingEntity)entity)) {
                    return;
                }
                if (timeOfDay >= 13000L && timeOfDay <= 23000L) {
                    if (target.m_21023_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get())) {
                        target.m_21195_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get());
                    }
                    target.m_147207_(new MobEffectInstance((MobEffect)MysticismMobEffects.LUNAR_BOOST.get(), 200, 0, false, false, false), (Entity)entity);
                    continue;
                }
                if (target.m_21023_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get())) {
                    target.m_21195_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get());
                }
                target.m_147207_(new MobEffectInstance((MobEffect)MysticismMobEffects.SOLAR_BOOST.get(), 200, 0, false, false, false), (Entity)entity);
            }
        }
        if (instance.getOrCreateTag().m_128471_("ShadowMerged")) {
            if (timeOfDay >= 13000L && timeOfDay <= 23000L) {
                if (entity.m_21023_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get())) {
                    entity.m_21195_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get());
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.LUNAR_BOOST.get(), 200, 0, false, false, false));
            } else {
                if (entity.m_21023_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get())) {
                    entity.m_21195_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get());
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.SOLAR_BOOST.get(), 200, 0, false, false, false));
            }
        }
    }

    private boolean canShadowStorage(LivingEntity target, LivingEntity entity) {
        IElementalSpirit spirit;
        if (target instanceof Player) {
            return false;
        }
        if (!SkillHelper.isSubordinate((LivingEntity)entity, (LivingEntity)target)) {
            return false;
        }
        if (target instanceof IElementalSpirit && (spirit = (IElementalSpirit)target).getSummoningTick() > 0) {
            return false;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.MONSTER)) {
            return true;
        }
        return !VainglorySkill.shouldConsumeAir(target);
    }

    public static boolean shouldConsumeAir(LivingEntity entity) {
        Player player;
        if (TensuraEPCapability.isMajin((LivingEntity)entity)) {
            return false;
        }
        if (RaceHelper.isSpiritualLifeForm((LivingEntity)entity)) {
            return false;
        }
        if (entity.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel((Enchantment)TensuraEnchantments.BREATHING_SUPPORT.get()) >= 1) {
            return false;
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        return !entity.m_5833_();
    }

    private void copyAttributes(LivingEntity originalEntity, LivingEntity shadowEntity) {
        ForgeRegistries.ATTRIBUTES.getValues().forEach(attribute -> {
            if (originalEntity.m_21204_().m_22171_(attribute) && shadowEntity.m_21204_().m_22171_(attribute)) {
                shadowEntity.m_21051_(attribute).m_22100_(originalEntity.m_21133_(attribute));
            }
        });
    }

    public void onDeath(ManasSkillInstance instance, LivingDeathEvent event) {
        LivingEntity livingEntity;
        CompoundTag tag = instance.getOrCreateTag();
        if (instance.getMastery() < 100) {
            return;
        }
        Entity killer = event.getSource().m_7639_();
        if (killer instanceof LivingEntity && !SkillUtils.hasSkill((Entity)killer, (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get())) && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                double requiredMagicule;
                double maxMagicule = cap.getBaseMagicule();
                double currentMagicule = cap.getMagicule();
                double d = requiredMagicule = instance.isMastered((LivingEntity)player) ? maxMagicule * 0.2 - 1.0 : maxMagicule * 0.25 - 1.0;
                if (currentMagicule >= requiredMagicule) {
                    cap.setMagicule(currentMagicule - requiredMagicule);
                    TensuraPlayerCapability.sync((Player)player);
                    event.setCanceled(true);
                    if (event.getEntity() instanceof Player) {
                        player.m_21153_(player.m_21233_());
                        TensuraEPCapability.setSpiritualHealth((LivingEntity)event.getEntity(), (double)TensuraEPCapability.getSpiritualHealth((LivingEntity)event.getEntity()));
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12287_, SoundSource.PLAYERS, 2.0f, 1.0f);
                    }
                    if (killer instanceof LivingEntity) {
                        double radius = 5.0;
                        double angle = Math.random() * 2.0 * Math.PI;
                        double distance = Math.random() * radius;
                        double offsetX = Math.cos(angle) * distance;
                        double offsetZ = Math.sin(angle) * distance;
                        BlockPos newPosition = new BlockPos(killer.m_20185_() + offsetX, killer.m_20186_(), killer.m_20189_() + offsetZ);
                        if (player.f_19853_.m_8055_(newPosition).m_60795_() && player.f_19853_.m_8055_(newPosition.m_7495_()).m_60783_((BlockGetter)player.f_19853_, newPosition.m_7495_(), Direction.UP)) {
                            player.m_6021_((double)newPosition.m_123341_() + 0.5, (double)newPosition.m_123342_(), (double)newPosition.m_123343_() + 0.5);
                        } else {
                            for (int i = 0; i < 5; ++i) {
                                double retryAngle = Math.random() * 2.0 * Math.PI;
                                double retryDistance = Math.random() * radius;
                                offsetX = Math.cos(retryAngle) * retryDistance;
                                offsetZ = Math.sin(retryAngle) * retryDistance;
                                BlockPos retryPosition = new BlockPos(killer.m_20185_() + offsetX, killer.m_20186_(), killer.m_20189_() + offsetZ);
                                if (!player.f_19853_.m_8055_(retryPosition).m_60795_() || !player.f_19853_.m_8055_(retryPosition.m_7495_()).m_60783_((BlockGetter)player.f_19853_, retryPosition.m_7495_(), Direction.UP)) continue;
                                player.m_6021_((double)retryPosition.m_123341_() + 0.5, (double)retryPosition.m_123342_(), (double)retryPosition.m_123343_() + 0.5);
                                break;
                            }
                        }
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.vainglory.death_prevented").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                    instance.addMasteryPoint((LivingEntity)player);
                } else if (tag.m_128471_("ShadowMerged")) {
                    this.removeShadowStats(player, instance);
                    String subordinateName = tag.m_128461_("ShadowName");
                    this.shadowStorageBackup.remove(player.m_20148_());
                    float reduction = tag.m_128457_("ShadowEP");
                    this.updateCurrentEP((LivingEntity)player, reduction, false);
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 0.8f);
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.plunderer.shadow_merge.end", (Object[])new Object[]{subordinateName}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    tag.m_128379_("ShadowMerged", false);
                    this.temporarySkillsMap.clear();
                }
            });
        }
    }

    public void onPressed(ManasSkillInstance instance, LivingEntity entity) {
        Level level = entity.m_9236_();
        if (instance.getMode() == 1) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                CompoundTag tag = instance.getOrCreateTag();
                ShadowSoulEntity target = (ShadowSoulEntity)SkillHelper.getTargetingEntity(ShadowSoulEntity.class, (LivingEntity)player, (double)5.0, (double)0.0, (boolean)true);
                this.summonShadowWarrior(target, instance, level, player, tag);
            }
        } else if (instance.getMode() == 2) {
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)entity, (double)5.0, (boolean)false);
            if (target == null) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_targeted").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else if (!this.canShadowStorage(target, entity)) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"tensura.targeting.not_allowed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                }
            } else {
                Player player;
                this.addMasteryPoint(instance, entity);
                level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
                ItemStack shadow = new ItemStack((ItemLike)TensuraMaterialItems.SHADOW_STORAGE.get());
                shadow.m_41714_((Component)Component.m_237110_((String)"tooltip.tensura.shadow_storage.name", (Object[])new Object[]{target.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
                CompoundTag compound = shadow.m_41784_();
                compound.m_128365_("ShadowData", (Tag)target.serializeNBT());
                compound.m_128347_("ShadowEP", TensuraEPCapability.getEP((LivingEntity)target));
                compound.m_128347_("ShadowHP", (double)target.m_21223_());
                compound.m_128347_("ShadowSHP", TensuraEPCapability.getSpiritualHealth((LivingEntity)target));
                compound.m_128359_("EntityType", String.valueOf(Registry.f_122826_.m_7981_((Object)target.m_6095_())));
                if (!(entity instanceof Player) || !(player = (Player)entity).m_36356_(shadow)) {
                    SkillHelper.dropItem((Entity)entity, (RandomSource)entity.m_217043_(), (ItemStack)shadow, (int)10, (float)0.5f);
                }
                target.m_146870_();
            }
        } else if (instance.getMode() == 3) {
            CompoundTag tag = instance.getOrCreateTag();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack heldItem = player.m_21205_();
                if (heldItem.m_41720_() == TensuraMaterialItems.SHADOW_STORAGE.get()) {
                    CompoundTag itemTag = heldItem.m_41783_();
                    String entityTypeKey = itemTag.m_128461_("EntityType");
                    EntityType entityType = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(entityTypeKey));
                    SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
                    boolean hasShadowMerged = playerStorage.getLearnedSkills().stream().anyMatch(skillInstance -> skillInstance.getOrCreateTag().m_128471_("ShadowMerged"));
                    if (!hasShadowMerged) {
                        if (itemTag.m_128441_("ShadowData") && entityType.equals(MysticismEntityTypes.SHADOW_SUBORDINATE.get())) {
                            this.applyShadowStats(player, instance, itemTag);
                            this.shadowStorageBackup.put(player.m_20148_(), heldItem.m_41777_());
                            heldItem.m_41774_(1);
                            tag.m_128379_("ShadowMerged", true);
                            double shadowEP = itemTag.m_128459_("ShadowEP");
                            tag.m_128350_("ShadowEP", (float)shadowEP);
                            this.updateCurrentEP((LivingEntity)player, (float)shadowEP, true);
                            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            LivingEntity subordinateEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)itemTag.m_128469_("ShadowData"), (Level)entity.f_19853_, happyHappy -> happyHappy);
                            if (subordinateEntity.m_7770_() != null) {
                                tag.m_128359_("ShadowName", subordinateEntity.m_7770_().getString());
                            } else {
                                tag.m_128359_("ShadowName", "Shadow Subordinate");
                            }
                            List<ManasSkillInstance> targetSkills = List.copyOf(SkillAPI.getSkillsFrom((Entity)subordinateEntity).getLearnedSkills().stream().toList());
                            if (!targetSkills.isEmpty()) {
                                ArrayList<ManasSkillInstance> tempLearnedSkills = new ArrayList<ManasSkillInstance>();
                                for (ManasSkillInstance targetInstance : targetSkills) {
                                    if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || targetInstance.getSkill() == this) continue;
                                    if (SkillUtils.learnSkill((LivingEntity)player, (ManasSkill)targetInstance.getSkill(), (int)-2)) {
                                        targetInstance.setRemoveTime(-2);
                                        tempLearnedSkills.add(targetInstance);
                                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.success_drain", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
                                        continue;
                                    }
                                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.already_have", (Object[])new Object[]{targetInstance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                                }
                                this.temporarySkillsMap.put(player.m_20148_(), tempLearnedSkills);
                            }
                            this.addMasteryPoint(instance, (LivingEntity)player);
                            player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.plunderer.shadow_merge.success", (Object[])new Object[]{subordinateEntity.m_7755_().getString()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.plunderer.shadow_merge.invalid").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.plunderer.shadow_merge.already_active").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                } else {
                    SkillStorage playerStorage = SkillAPI.getSkillsFrom((Entity)player);
                    boolean hasShadowMerged = playerStorage.getLearnedSkills().stream().anyMatch(skillInstance -> skillInstance.getOrCreateTag().m_128471_("ShadowMerged"));
                    if (hasShadowMerged && tag.m_128471_("ShadowMerged")) {
                        this.removeShadowStats(player, instance);
                        String subordinateName = tag.m_128461_("ShadowName");
                        float reduction = tag.m_128457_("ShadowEP");
                        this.updateCurrentEP((LivingEntity)player, reduction, false);
                        if (player.m_21023_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get()) || player.m_21023_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get())) {
                            player.m_21195_((MobEffect)MysticismMobEffects.LUNAR_BOOST.get());
                            player.m_21195_((MobEffect)MysticismMobEffects.SOLAR_BOOST.get());
                        }
                        ItemStack backup = this.shadowStorageBackup.remove(player.m_20148_());
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12052_, SoundSource.PLAYERS, 1.0f, 0.8f);
                        player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.plunderer.shadow_merge.end", (Object[])new Object[]{subordinateName}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                        tag.m_128379_("ShadowMerged", false);
                        UUID playerUUID = player.m_20148_();
                        List<ManasSkillInstance> tempLearnedSkills = this.temporarySkillsMap.get(playerUUID);
                        if (tempLearnedSkills != null) {
                            for (ManasSkillInstance skillInstance2 : tempLearnedSkills) {
                                if (skillInstance2.getRemoveTime() != -2) continue;
                                playerStorage.forgetSkill(skillInstance2);
                                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.remove", (Object[])new Object[]{skillInstance2.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), false);
                            }
                            playerStorage.syncChanges();
                            this.temporarySkillsMap.remove(playerUUID);
                        }
                        instance.setCoolDown(10);
                        if (!player.m_36356_(backup)) {
                            SkillHelper.dropItem((Entity)entity, (RandomSource)entity.m_217043_(), (ItemStack)backup, (int)10, (float)0.5f);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.plunderer.shadow_merge.error").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            }
        }
    }

    private void summonShadowWarrior(ShadowSoulEntity target, ManasSkillInstance instance, Level level, Player player, CompoundTag tag) {
        if (target == null || !target.m_6084_()) {
            return;
        }
        if (!target.hasOriginalMobData()) {
            return;
        }
        CompoundTag mobData = target.getOriginalMobData();
        LivingEntity originalEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, boy -> boy);
        if (originalEntity != null) {
            double playerMP;
            double magiculeCost = TensuraEPCapability.getEP((LivingEntity)originalEntity);
            if (magiculeCost > (playerMP = TensuraPlayerCapability.getMagicule((Player)player))) {
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.plunderer.shadow_warrior.fail").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            } else {
                tag.m_128347_("SubordinateMPCost", magiculeCost);
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setMagicule(cap.getMagicule() - magiculeCost);
                    TensuraPlayerCapability.sync((Player)player);
                });
                ShadowSubordinateEntity shadowEntity = new ShadowSubordinateEntity(originalEntity.f_19853_, new BlockPos(originalEntity.m_20185_(), originalEntity.m_20186_(), originalEntity.m_20189_()), originalEntity);
                shadowEntity.m_20084_(UUID.randomUUID());
                shadowEntity.setOriginalMobData(originalEntity);
                shadowEntity.m_21828_(player);
                shadowEntity.m_217045_();
                CompoundTag tags = target.getPersistentData();
                tags.m_128379_("NO_EP_PLUNDER", true);
                tags.m_128379_("NO_SKILL_PLUNDER", true);
                tags.m_128379_("no_loot", true);
                TensuraEPCapability.setMajin((LivingEntity)shadowEntity, (boolean)true);
                shadowEntity.m_6034_(originalEntity.m_20185_(), originalEntity.m_20186_(), originalEntity.m_20189_());
                shadowEntity.m_6593_(originalEntity.m_7770_());
                this.setStats(originalEntity, shadowEntity);
                shadowEntity.setHeight(originalEntity.m_20206_());
                shadowEntity.setWidth(originalEntity.m_20205_());
                if (level.m_7967_((Entity)shadowEntity)) {
                    this.copyAttributes(originalEntity, (LivingEntity)shadowEntity);
                    this.copySkills(originalEntity, shadowEntity);
                    target.m_146870_();
                    shadowEntity.m_21153_(shadowEntity.m_21233_());
                    shadowEntity.f_19853_.m_6269_(null, (Entity)shadowEntity, SoundEvents.f_12513_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)shadowEntity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
                    this.addMasteryPoint(instance, (LivingEntity)player, 3);
                }
            }
        }
    }

    private void copySkills(LivingEntity originalEntity, ShadowSubordinateEntity shadowSubordinate) {
        SkillStorage originalStorage = SkillAPI.getSkillsFrom((Entity)originalEntity);
        SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)shadowSubordinate);
        for (ManasSkillInstance instances : originalStorage.getLearnedSkills()) {
            if (instances.isTemporarySkill() || instances.getMastery() < 0) continue;
            targetStorage.learnSkill(instances);
        }
    }

    private void updateCurrentEP(LivingEntity entity, float amount, boolean add) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float finalAmount = amount / 2.0f;
            AttributeInstance aura = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
            AttributeInstance magicule = entity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
            AttributeModifier shadow = new AttributeModifier(SHADOW_MERGE, "Shadow Merge EP Boost", (double)finalAmount, AttributeModifier.Operation.ADDITION);
            if (add) {
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setMagicule(cap.getMagicule() + (double)finalAmount);
                    cap.setAura(cap.getAura() + (double)finalAmount);
                });
                if (aura != null) {
                    aura.m_22125_(shadow);
                }
                if (magicule != null) {
                    magicule.m_22125_(shadow);
                }
            } else {
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    cap.setMagicule(cap.getMagicule() - (double)finalAmount);
                    cap.setAura(cap.getAura() - (double)finalAmount);
                });
                if (aura != null) {
                    aura.m_22120_(SHADOW_MERGE);
                }
                if (magicule != null) {
                    magicule.m_22120_(SHADOW_MERGE);
                }
            }
            TensuraPlayerCapability.sync((Player)player);
        }
    }

    private void modifyShadowStats(Player entity, CompoundTag shadowData, boolean add) {
        Set<Attribute> excludedAttributes = Set.of(Attributes.f_22277_, (Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get(), (Attribute)TensuraAttributeRegistry.MAX_AURA.get(), (Attribute)TensuraAttributeRegistry.SIZE.get(), (Attribute)ForgeMod.ENTITY_GRAVITY.get(), (Attribute)ManasCoreAttributes.CRIT_CHANCE.get(), (Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get(), Attributes.f_22287_, Attributes.f_22288_, Attributes.f_22286_);
        if (shadowData == null) {
            return;
        }
        Entity subordinateEntity = EntityType.m_20645_((CompoundTag)shadowData, (Level)entity.f_19853_, e -> e);
        if (!(subordinateEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity subordinate = (LivingEntity)subordinateEntity;
        for (AttributeInstance subordinateAttr : subordinate.m_21204_().m_22170_()) {
            AttributeInstance playerAttr;
            Attribute attribute = subordinateAttr.m_22099_();
            if (excludedAttributes.contains(attribute) || (playerAttr = entity.m_21051_(attribute)) == null) continue;
            double subordinateValue = subordinateAttr.m_22115_();
            double modificationValue = add ? subordinateValue : -subordinateValue;
            AttributeModifier modifier = new AttributeModifier(SHADOW_MERGE, "Shadow Merge Boost", modificationValue, AttributeModifier.Operation.ADDITION);
            if (add) {
                if (playerAttr.m_22109_(modifier)) continue;
                playerAttr.m_22125_(modifier);
                continue;
            }
            playerAttr.m_22130_(modifier);
        }
    }

    private void applyShadowStats(Player player, ManasSkillInstance instance, CompoundTag tag) {
        if (tag.m_128441_("ShadowData")) {
            CompoundTag shadowData = tag.m_128469_("ShadowData");
            String entityTypeKey = tag.m_128461_("EntityType");
            instance.getOrCreateTag().m_128365_("SavedShadowData", (Tag)shadowData);
            EntityType entityType = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(entityTypeKey));
            Level level = player.f_19853_;
            Entity shadowEntity = entityType.m_20615_(level);
            if (shadowEntity != null) {
                shadowEntity.m_20258_(shadowData);
                if (shadowEntity instanceof LivingEntity) {
                    this.modifyShadowStats(player, shadowData, true);
                    double shadowHP = tag.m_128459_("ShadowHP");
                    double shadowSHP = tag.m_128459_("ShadowSHP");
                    player.m_21153_((float)(shadowHP + (double)player.m_21223_()));
                    TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)(TensuraEPCapability.getSpiritualHealth((LivingEntity)player) + shadowSHP));
                }
            }
        }
    }

    private void removeShadowStats(Player player, ManasSkillInstance instance) {
        CompoundTag savedShadowData = instance.getOrCreateTag().m_128469_("SavedShadowData");
        if (!savedShadowData.m_128456_()) {
            this.modifyShadowStats(player, savedShadowData, false);
            instance.getTag().m_128473_("SavedShadowData");
            player.m_21153_(player.m_21223_());
            TensuraEPCapability.setSpiritualHealth((LivingEntity)player, (double)TensuraEPCapability.getSpiritualHealth((LivingEntity)player));
        }
    }
}

