/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.ability.skill.unique;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class VictoriousHarbingerSkill
extends Skill {
    protected static final UUID RELENTLESS_BARRAGE = UUID.fromString("b529e3fe-c443-413a-a319-059284f9d400");
    public static final ImmutableList<MobEffect> COURAGE_OF_THE_STRONG = ImmutableList.of((Object)((MobEffect)TensuraMobEffects.FEAR.get()), (Object)((MobEffect)TensuraMobEffects.MIND_CONTROL.get()));

    public VictoriousHarbingerSkill() {
        super(Skill.SkillType.UNIQUE);
    }

    public ResourceLocation getSkillIcon() {
        return new ResourceLocation("trmysticism", "textures/skill/unique/victorious_harbinger.png");
    }

    public double getObtainingEpCost() {
        return 80000.0;
    }

    public int modes() {
        return 2;
    }

    public int nextMode(@NotNull LivingEntity entity, @NotNull TensuraSkillInstance instance, boolean reverse) {
        if (reverse) {
            return instance.getMode() == 1 ? 2 : instance.getMode() - 1;
        }
        return instance.getMode() == 2 ? 1 : instance.getMode() + 1;
    }

    public double magiculeCost(@NotNull LivingEntity entity, ManasSkillInstance instance) {
        return switch (instance.getMode()) {
            case 1 -> 2000.0;
            case 2 -> 500.0;
            default -> 0.0;
        };
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity living) {
        return instance.getMastery() >= 0;
    }

    @NotNull
    public Component getModeName(int mode) {
        return switch (mode) {
            case 1 -> Component.m_237115_((String)"trmysticism.skill.mode.victorious_harbinger.might");
            case 2 -> Component.m_237115_((String)"trmysticism.skill.mode.victorious_harbinger.tenacious_resolve");
            default -> Component.m_237119_();
        };
    }

    public double getAttributeModifierAmplifier(ManasSkillInstance instance, @NotNull LivingEntity entity, AttributeModifier modifier) {
        return modifier.m_22218_() * (instance.isMastered(entity) ? 0.9473684210526315 : 1.0);
    }

    public void addHeldAttributeModifiers(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.getMode() == 1) {
            super.addHeldAttributeModifiers(instance, entity);
        }
    }

    public void onToggleOn(@NotNull ManasSkillInstance instance, LivingEntity entity) {
        AttributeModifier speedModifier;
        AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
        if (attackSpeed != null && !attackSpeed.m_22109_(speedModifier = new AttributeModifier(RELENTLESS_BARRAGE, "Relentless Barrage", 0.1, AttributeModifier.Operation.MULTIPLY_BASE))) {
            attackSpeed.m_22125_(speedModifier);
        }
    }

    public void onToggleOff(@NotNull LivingEntity entity) {
        AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
        if (attackSpeed != null) {
            attackSpeed.m_22127_(RELENTLESS_BARRAGE);
        }
    }

    public void onPressed(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        if (instance.getMode() == 2) {
            for (MobEffectInstance effect : entity.m_21220_()) {
                MobEffect mobEffect = effect.m_19544_();
                if (mobEffect.m_19483_() != MobEffectCategory.HARMFUL) continue;
                int oldAmplifier = effect.m_19564_();
                int newAmplifier = Math.max(0, oldAmplifier - 1);
                int oldDuration = effect.m_19557_();
                int newDuration = (int)((float)oldDuration * 0.75f);
                entity.m_21195_(mobEffect);
                entity.m_7292_(new MobEffectInstance(mobEffect, newDuration, newAmplifier, effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
            }
            instance.addMasteryPoint(entity);
            instance.setCoolDown(60);
        }
    }

    public boolean onHeld(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() != 1) {
            return false;
        }
        if (heldTicks % 20 == 0 && SkillHelper.outOfMagicule((LivingEntity)entity, (ManasSkillInstance)instance)) {
            return false;
        }
        if (heldTicks % 100 == 0 && heldTicks > 0) {
            this.addMasteryPoint(instance, entity);
        }
        VictoriousHarbingerSkill.activateMight(instance, entity, heldTicks);
        return true;
    }

    public static void activateMight(ManasSkillInstance instance, LivingEntity entity, int heldTicks) {
        List list;
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (heldTicks % 2 == 0) {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:demon_lord_haki"), entity.m_19879_(), 0.0, 1.0, 0.0, true));
        }
        if (!(list = entity.m_9236_().m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(10.0), living -> !living.m_7306_((Entity)entity) && living.m_6084_() && !living.m_7307_((Entity)entity))).isEmpty()) {
            double scale = instance.getTag() == null ? 0.0 : instance.getTag().m_128459_("scale");
            double multiplier = scale == 0.0 ? 1.0 : Math.min(scale, 1.0);
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)entity) * multiplier;
            for (LivingEntity target : list) {
                double targetEP;
                double difference;
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (player.m_150110_().f_35934_) continue;
                }
                if ((difference = ownerEP / (targetEP = TensuraEPCapability.getEP((LivingEntity)target))) <= 2.0) continue;
                int fearLevel = (int)(difference * 0.5 - 1.0);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource((LivingEntity)target, (Entity)entity, (MobEffect)((MobEffect)TensuraMobEffects.FEAR.get()), (int)200, (int)fearLevel);
                HakiSkill.hakiPush((LivingEntity)target, (LivingEntity)entity, (int)fearLevel);
            }
        }
    }

    public void onScroll(ManasSkillInstance instance, @NotNull LivingEntity entity, double delta) {
        if (instance.getMode() == 1) {
            HakiSkill.changeEPUsed((ManasSkillInstance)instance, (LivingEntity)entity, (double)delta);
        }
    }

    public void onRelease(ManasSkillInstance instance, @NotNull LivingEntity entity, int heldTicks) {
        if (instance.getMode() == 1 && this.hasAttributeApplied(entity, Attributes.f_22279_, "2e430fc9-a0b6-46e2-8cd2-9c87262344ea")) {
            instance.setCoolDown(40);
        }
    }

    @NotNull
    public List<MobEffect> getImmuneEffects(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return SkillUtils.hasSkill((Entity)entity, (ManasSkill)instance.getSkill()) ? new ArrayList() : COURAGE_OF_THE_STRONG;
    }
}

