/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.api;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.api.ContractIDManager;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;

public class Contract {
    private final int id;
    private UUID contractorUUID;
    private UUID contracteeUUID;
    private int grantedTier;
    private long arrivalTime;
    private boolean isTrueDemonLord;
    private boolean isTrueHero;
    private Component name;
    private Race race;
    private static final String NBT_GRANTED_TIER = "grantedTier";
    private MagicElemental element;
    private double existencePoints;
    private double maxMagicules;
    private double maxAura;

    public Contract(Player contractor, Player contractee) {
        this.id = ContractIDManager.getNextId();
        this.contractorUUID = contractor.m_20148_();
        this.contracteeUUID = contractee.m_20148_();
        this.arrivalTime = contractor.f_19853_.m_46467_();
        TensuraPlayerCapability.getFrom((Player)contractor).ifPresent(cap -> {
            this.isTrueDemonLord = cap.isTrueDemonLord();
            this.isTrueHero = cap.isTrueHero();
            this.race = cap.getRace();
        });
        TensuraEPCapability.getFrom((LivingEntity)contractor).ifPresent(cap -> {
            this.name = cap.getName() != null ? Component.m_237113_((String)cap.getName()) : contractor.m_7755_();
            this.existencePoints = cap.getEP();
        });
        MysticismPlayerCapability.getFrom(contractor).ifPresent(cap -> {
            this.element = cap.getElement();
        });
        this.maxMagicules = contractor.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
        this.maxAura = contractor.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
    }

    public Contract(int id, UUID contractorUUID, UUID contracteeUUID, long arrivalTime, boolean isTrueDemonLord, boolean isTrueHero, Component name, Race race, MagicElemental element, double existencePoints, double maxMagicules, double maxAura) {
        ContractIDManager.registerLoadedId(id);
        this.id = id;
        this.contractorUUID = contractorUUID;
        this.contracteeUUID = contracteeUUID;
        this.arrivalTime = arrivalTime;
        this.isTrueDemonLord = isTrueDemonLord;
        this.isTrueHero = isTrueHero;
        this.name = name;
        this.race = race;
        this.element = element;
        this.existencePoints = existencePoints;
        this.maxMagicules = maxMagicules;
        this.maxAura = maxAura;
    }

    public int getId() {
        return this.id;
    }

    public UUID getContractorUUID() {
        return this.contractorUUID;
    }

    public int getGrantedTier() {
        return this.grantedTier;
    }

    public void setGrantedTier(int tier) {
        if (tier < 0) {
            tier = 0;
        }
        if (tier > 5) {
            tier = 5;
        }
        this.grantedTier = tier;
    }

    public UUID getContracteeUUID() {
        return this.contracteeUUID;
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public boolean isTrueDemonLord() {
        return this.isTrueDemonLord;
    }

    public boolean isTrueHero() {
        return this.isTrueHero;
    }

    public Component getName() {
        return this.name;
    }

    public Race getRace() {
        return this.race;
    }

    public MagicElemental getElement() {
        return this.element;
    }

    public double getExistencePoints() {
        return this.existencePoints;
    }

    public double getMaxMagicules() {
        return this.maxMagicules;
    }

    public double getMaxAura() {
        return this.maxAura;
    }

    public void invalidate() {
        ContractIDManager.releaseId(this.id);
    }

    public CompoundTag save() {
        CompoundTag contractTag = new CompoundTag();
        contractTag.m_128405_("contractId", this.getId());
        contractTag.m_128362_("contractorUUID", this.getContractorUUID());
        contractTag.m_128362_("contracteeUUID", this.getContracteeUUID());
        contractTag.m_128356_("arrivalTime", this.getArrivalTime());
        contractTag.m_128379_("isTrueDemonLord", this.isTrueDemonLord());
        contractTag.m_128379_("isTrueHero", this.isTrueHero());
        contractTag.m_128359_("name", this.getName().getString());
        contractTag.m_128359_("raceId", this.getRace().getRegistryName().toString());
        if (this.getElement() != null) {
            contractTag.m_128405_("elementId", this.getElement().ordinal());
        }
        contractTag.m_128347_("existencePoints", this.getExistencePoints());
        contractTag.m_128347_("maxMagicules", this.getMaxMagicules());
        contractTag.m_128347_("maxAura", this.getMaxAura());
        if (this.getGrantedTier() > 0) {
            contractTag.m_128405_(NBT_GRANTED_TIER, this.getGrantedTier());
        }
        return contractTag;
    }

    public static Contract load(CompoundTag contractTag) {
        int id = contractTag.m_128451_("contractId");
        UUID contractorUUID = contractTag.m_128342_("contractorUUID");
        UUID contracteeUUID = contractTag.m_128342_("contracteeUUID");
        long arrivalTime = contractTag.m_128454_("arrivalTime");
        boolean isTrueDemonLord = contractTag.m_128471_("isTrueDemonLord");
        boolean isTrueHero = contractTag.m_128471_("isTrueHero");
        String name = contractTag.m_128461_("name");
        Race race = (Race)((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(new ResourceLocation(contractTag.m_128461_("raceId")));
        MagicElemental element = contractTag.m_128441_("elementId") ? MagicElemental.values()[contractTag.m_128451_("elementId")] : null;
        double existencePoints = contractTag.m_128459_("existencePoints");
        double maxMagicules = contractTag.m_128459_("maxMagicules");
        double maxAura = contractTag.m_128459_("maxAura");
        Contract c = new Contract(id, contractorUUID, contracteeUUID, arrivalTime, isTrueDemonLord, isTrueHero, (Component)Component.m_237113_((String)name), race, element, existencePoints, maxMagicules, maxAura);
        int grantedTier = contractTag.m_128441_(NBT_GRANTED_TIER) ? contractTag.m_128451_(NBT_GRANTED_TIER) : 0;
        c.setGrantedTier(grantedTier);
        return c;
    }
}

