/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.api;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ContractIDManager {
    private static final Deque<Integer> AVAILABLE_IDS = new LinkedList<Integer>();
    private static final Set<Integer> USED_IDS = new HashSet<Integer>();
    private static int nextId = 0;

    public static synchronized int getNextId() {
        if (!AVAILABLE_IDS.isEmpty()) {
            int id = AVAILABLE_IDS.poll();
            USED_IDS.add(id);
            return id;
        }
        USED_IDS.add(nextId);
        return nextId++;
    }

    public static synchronized void releaseId(int id) {
        if (USED_IDS.remove(id)) {
            AVAILABLE_IDS.offer(id);
        }
    }

    public static synchronized void registerLoadedId(int id) {
        USED_IDS.add(id);
        if (id >= nextId) {
            nextId = id + 1;
        }
    }
}

