/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.api;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.item.templates.SimpleAxeItem;
import com.github.manasmods.tensura.item.templates.SimpleSwordItem;
import com.github.manasmods.tensura.item.templates.WandItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleSickleItem;
import com.github.manasmods.tensura.item.templates.custom.SimpleSpearItem;
import io.github.Memoires.trmysticism.menu.WeaponStorageUltMenu;
import io.github.Memoires.trmysticism.menu.container.WeaponStorageContainer;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2client.ClientboundWeaponStorageUltOpenPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;

public interface IWeaponStorageUlt {
    default public WeaponStorageContainer getWeaponStorage(ManasSkillInstance instance, LivingEntity entity) {
        int size = 20;
        return new WeaponStorageContainer(size, 64);
    }

    default public void openWeaponStorage(LivingEntity entity, ManasSkillInstance instance) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_6915_();
            player.m_9217_();
            player.m_6330_(SoundEvents.f_11889_, SoundSource.PLAYERS, 1.0f, 1.0f);
            ManasSkill skill = instance.getSkill();
            WeaponStorageContainer container = this.getWeaponStorage(instance, entity);
            MysticismNetwork.sendTo(new ClientboundWeaponStorageUltOpenPacket(player.m_19879_(), player.f_8940_, container.m_6643_(), container.m_6893_(), SkillUtils.getSkillId((ManasSkill)skill)), (LivingEntity)player);
            player.f_36096_ = new WeaponStorageUltMenu(player.f_8940_, player.m_150109_(), (Player)player, container, skill);
            player.m_143399_(player.f_36096_);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
        }
    }

    default public boolean addItemToWeaponStorage(ManasSkillInstance instance, LivingEntity entity, ItemStack stack) {
        if (!this.isWeapon(stack)) {
            return false;
        }
        WeaponStorageContainer container = this.getWeaponStorage(instance, entity);
        if (container.m_19183_(stack)) {
            container.m_19173_(stack);
            this.saveContainer(instance, entity, container);
            return true;
        }
        this.saveContainer(instance, entity, container);
        return false;
    }

    default public void setItemInWeaponStorage(ManasSkillInstance instance, LivingEntity entity, ItemStack stack, int slot) {
        if (!this.isWeapon(stack)) {
            return;
        }
        WeaponStorageContainer container = this.getWeaponStorage(instance, entity);
        container.m_6836_(slot, stack);
        this.saveContainer(instance, entity, container);
    }

    default public void moveItemsToWeaponStorage(ManasSkillInstance from, ManasSkillInstance to, LivingEntity entity, boolean openNewStorage) {
        IWeaponStorageUlt newStorage = (IWeaponStorageUlt)to.getSkill();
        WeaponStorageContainer container = this.getWeaponStorage(from, entity);
        if (!container.m_7983_()) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                Player player;
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || newStorage.addItemToWeaponStorage(to, entity, stack) || !(entity instanceof Player) || (player = (Player)entity).m_36356_(stack)) continue;
                player.m_36176_(stack, false);
            }
            container.m_6211_();
            from.getOrCreateTag().m_128473_("SpatialStorage");
            from.markDirty();
        }
        if (openNewStorage) {
            newStorage.openWeaponStorage(entity, to);
        }
    }

    default public void dropAllItems(ManasSkillInstance instance, Player player) {
        WeaponStorageContainer container = this.getWeaponStorage(instance, (LivingEntity)player);
        if (!container.m_7983_()) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_() || player.m_36356_(stack)) continue;
                player.m_36176_(stack, false);
            }
            container.m_6211_();
            instance.getOrCreateTag().m_128473_("SpatialStorage");
            instance.markDirty();
        }
    }

    default public void saveContainer(ManasSkillInstance instance, LivingEntity entity, WeaponStorageContainer container) {
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128365_("SpatialStorage", (Tag)container.m_7927_());
        instance.markDirty();
        SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
    }

    default public boolean isWeapon(ItemStack stack) {
        Item item = stack.m_41720_();
        return item instanceof SwordItem || item instanceof AxeItem || item instanceof SimpleSpearItem || item instanceof SimpleSwordItem || item instanceof SimpleAxeItem || item instanceof WandItem || item instanceof SimpleSickleItem;
    }
}

