/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.capability.race;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.ITensuraSkillCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapabilityProvider;
import io.github.Memoires.trmysticism.handlers.CapabilityHandler;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2client.AddContractRequestPacket;
import io.github.Memoires.trmysticism.network.play2client.DissolveActiveContractPacket;
import io.github.Memoires.trmysticism.network.play2client.DissolveContractPacket;
import io.github.Memoires.trmysticism.network.play2client.SyncPlayerCapabilityPacket;
import io.github.Memoires.trmysticism.network.play2client.UpdateAcceptedContractPacket;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.util.ContractMagicTable;
import io.github.Memoires.trmysticism.world.ContractLedger;
import io.github.Memoires.trmysticism.world.MilimReincarnation;
import io.github.Memoires.trmysticism.world.MysticismGamerules;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MysticismPlayerCapability
implements IMysticismPlayerCapability {
    public static final Capability<IMysticismPlayerCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IMysticismPlayerCapability>(){});
    private static final ResourceLocation ID = new ResourceLocation("trmysticism", "player_cap");
    private Player owner;
    private MagicElemental element;
    private GameType savedGamemode;
    private boolean isSpirit;
    private Contract activeContract;
    private final List<Contract> pendingContracts = new ArrayList<Contract>();
    private final Map<MagicElemental, Contract> acceptedContracts = new EnumMap<MagicElemental, Contract>(MagicElemental.class);
    private boolean shouldIgnoreSpectator = false;
    private boolean isSummoned = false;
    private int soulQuality;
    private int currentUltimates = 0;
    @Nullable
    private UUID pendingCameraTarget;
    private int cameraRetryTicks;
    private int lightningStrikes;

    @Override
    @Nullable
    public UUID getPendingCameraTarget() {
        return this.pendingCameraTarget;
    }

    @Override
    public void setPendingCameraTarget(@Nullable UUID v) {
        this.pendingCameraTarget = v;
    }

    @Override
    public int getCameraRetryTicks() {
        return this.cameraRetryTicks;
    }

    @Override
    public void setCameraRetryTicks(int t) {
        this.cameraRetryTicks = t;
    }

    @SubscribeEvent
    public static void attach(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof Player) {
            e.addCapability(ID, (ICapabilityProvider)new MysticismPlayerCapabilityProvider());
        }
    }

    public static LazyOptional<IMysticismPlayerCapability> getFrom(Player player) {
        @NotNull LazyOptional lazyCap = player.getCapability(CAPABILITY);
        lazyCap.ifPresent(cap -> cap.setOwner(player));
        return lazyCap;
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MysticismPlayerCapability.getFrom((Player)serverPlayer).ifPresent(data -> MysticismNetwork.sendToAllTrackingAndSelf(new SyncPlayerCapabilityPacket((IMysticismPlayerCapability)data, serverPlayer.m_19879_()), (LivingEntity)serverPlayer));
        }
    }

    public static void setElement(Player player, MagicElemental element) {
        IMysticismPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return;
        }
        capability.setElement(element);
    }

    public void setLightningStrikes(Player player, int strikes) {
        IMysticismPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return;
        }
        capability.setLightningStrikes(strikes);
    }

    @Override
    public void setSavedGamemode(GameType type) {
        this.savedGamemode = type;
    }

    @Override
    public GameType getSavedGamemode() {
        return this.savedGamemode;
    }

    public static boolean hasTimeStop(@Nullable LivingEntity entity) {
        LocalPlayer localPlayer;
        Player player;
        return !(entity == null || !entity.m_21023_(new MobEffectInstance((MobEffect)MysticismMobEffects.TIMESTOP.get()).m_19544_()) && !entity.m_21023_(new MobEffectInstance((MobEffect)MysticismMobEffects.TIMESTOP.get()).m_19544_()) || entity.m_5833_() || entity instanceof Player && (player = (Player)entity).m_7500_() || entity.m_21224_() || entity instanceof LocalPlayer && (localPlayer = (LocalPlayer)entity).m_242612_());
    }

    @Override
    public void incrementLightningStrikes() {
        ++this.lightningStrikes;
    }

    @Override
    public int getSoulQuality() {
        return this.soulQuality;
    }

    @Override
    public void setSoulQuality(int soulQuality) {
        this.soulQuality = soulQuality;
    }

    @Override
    public void setCurrentUltimates(int currentUltimates) {
        this.currentUltimates = currentUltimates;
    }

    @Override
    public int getCurrentUltimates() {
        return this.currentUltimates;
    }

    public static MagicElemental getElement(Player player) {
        IMysticismPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        return capability == null ? null : capability.getElement();
    }

    public static void setRandomElement(Player player) {
        IMysticismPlayerCapability capability = CapabilityHandler.getCapability((Entity)player, CAPABILITY);
        if (capability == null) {
            return;
        }
        MagicElemental element = MagicElemental.values()[player.f_19853_.m_213780_().m_188503_(MagicElemental.values().length)];
        capability.setElement(element);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MysticismPlayerCapability.sync((Player)serverPlayer);
        }
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player owner) {
        if (this.owner == null) {
            this.owner = owner;
        }
    }

    @Override
    public Contract getActiveContract() {
        return this.activeContract;
    }

    @Override
    public void setActiveContract(Contract contract) {
        this.activeContract = contract;
    }

    @Override
    public Contract getContractForElement(MagicElemental element) {
        return this.acceptedContracts.get(element);
    }

    @Override
    public List<Contract> getPendingContracts() {
        return Collections.unmodifiableList(this.pendingContracts);
    }

    @Override
    public Map<MagicElemental, Contract> getAcceptedContracts() {
        return this.acceptedContracts;
    }

    @Override
    public boolean offerContract(Contract contract) {
        if (contract == null) {
            return false;
        }
        this.pendingContracts.add(contract);
        if (!this.getOwner().f_19853_.f_46443_) {
            MysticismNetwork.sendTo(new AddContractRequestPacket(contract), (LivingEntity)this.getOwner());
        }
        return true;
    }

    @Override
    public boolean acceptContract(Contract contract) {
        if (contract == null) {
            return false;
        }
        if (!this.pendingContracts.contains(contract)) {
            return false;
        }
        MagicElemental element = contract.getElement();
        if (element == null) {
            return false;
        }
        if (this.acceptedContracts.containsKey(element)) {
            return false;
        }
        Player contractor = this.getOwner().f_19853_.m_46003_(contract.getContractorUUID());
        Player contractee = this.getOwner().f_19853_.m_46003_(contract.getContracteeUUID());
        if (contractor == null || contractee == null) {
            return false;
        }
        TensuraEPCapability.getFrom((LivingEntity)contractor).ifPresent(contractorCap -> contractorCap.setTemporaryOwner(contractee.m_20148_()));
        int tier = this.spiritLevel(contractor);
        contract.setGrantedTier(tier);
        LazyOptional skillCapLO = TensuraSkillCapability.getFrom((Player)contractee);
        ITensuraSkillCapability skillCap = (ITensuraSkillCapability)skillCapLO.orElse(null);
        if (skillCap != null) {
            int existing = skillCap.getSpiritLevel(element.getId());
            if (existing > tier) {
                contractee.m_5661_((Component)Component.m_237110_((String)"trmysticism.message.contract.spirit_level_too_low.other", (Object[])new Object[]{contractor.m_5446_(), element.getName()}).m_130940_(ChatFormatting.RED), false);
                contractor.m_5661_((Component)Component.m_237110_((String)"trmysticism.message.contract.spirit_level_too_low.self", (Object[])new Object[]{contractee.m_5446_(), element.getName()}).m_130940_(ChatFormatting.RED), false);
                return false;
            }
            skillCap.setSpiritLevel(contractee, element.getId(), tier);
            TensuraSkillCapability.sync((Player)contractee);
        }
        this.acceptedContracts.put(element, contract);
        this.pendingContracts.remove(contract);
        ServerLevel srv = ((ServerPlayer)contractor).m_9236_();
        ContractLedger ledger = ContractLedger.get(srv);
        ContractLedger.Entry entry = new ContractLedger.Entry();
        entry.id = contract.getId();
        entry.contractor = contract.getContractorUUID();
        entry.contractee = contract.getContracteeUUID();
        entry.element = element;
        entry.status = ContractLedger.Status.ACTIVE;
        entry.updatedAt = System.currentTimeMillis();
        ledger.upsert(entry);
        MysticismPlayerCapability.getFrom(contractor).ifPresent(cap -> {
            cap.setActiveContract(contract);
            this.provideMagic(element, contractor, contractee);
            if (contractor instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)contractor;
                cap.setSavedGamemode(sp.f_8941_.m_9290_());
                sp.m_143403_(GameType.SPECTATOR);
                sp.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)contractee));
            }
        });
        if (!this.getOwner().f_19853_.f_46443_) {
            MysticismNetwork.sendTo(new UpdateAcceptedContractPacket(contract), (LivingEntity)this.getOwner());
        }
        return true;
    }

    private void provideMagic(MagicElemental contractorElement, Player contractor, Player contractee) {
        int tier = this.spiritLevel(contractor);
        if (contractee instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)contractee;
            ContractMagicTable.grant(sp, contractorElement, tier);
        }
    }

    private int spiritLevel(Player spirit) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)spirit);
        if (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT))) {
            return 1;
        }
        if (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT))) {
            return 2;
        }
        if (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT))) {
            return 3;
        }
        if (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD))) {
            return 4;
        }
        return 5;
    }

    @Override
    public void restoreGamemodeIfSpectator(ServerPlayer sp) {
        if (sp.f_8941_.m_9290_() == GameType.SPECTATOR) {
            GameType saved = this.getSavedGamemode();
            sp.m_143403_(saved != null ? saved : GameType.SURVIVAL);
            TensuraPlayerCapability.getFrom((Player)sp).ifPresent(tensuraCap -> tensuraCap.setSpiritualForm(true));
        }
        this.setSavedGamemode(null);
    }

    @Override
    public boolean dissolveContract(Contract contract) {
        if (contract == null) {
            return false;
        }
        MagicElemental element = contract.getElement();
        int contractId = contract.getId();
        if (this.acceptedContracts.remove(element) == null) {
            return false;
        }
        Player contractor = this.getOwner().f_19853_.m_46003_(contract.getContractorUUID());
        Player contractee = this.getOwner().f_19853_.m_46003_(contract.getContracteeUUID());
        ServerLevel srv = (ServerLevel)contractee.f_19853_;
        if (element != null) {
            TensuraSkillCapability.getFrom((Player)contractee).ifPresent(cap -> {
                cap.setSpiritLevel(contractee, element.getId(), 0);
                TensuraSkillCapability.sync((Player)contractee);
            });
        }
        if (contractor instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)contractor;
            MysticismPlayerCapability.getFrom(contractor).ifPresent(cap -> {
                if (cap.getSavedGamemode() != null) {
                    cap.setSummonStatus(true);
                    sp.m_143403_(cap.getSavedGamemode());
                    cap.setSavedGamemode(null);
                } else {
                    sp.m_143403_(GameType.SURVIVAL);
                }
                sp.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)sp));
            });
            TensuraEPCapability.getFrom((LivingEntity)sp).ifPresent(contractorCap -> contractorCap.setTemporaryOwner(null));
            TensuraPlayerCapability.getFrom((Player)sp).ifPresent(contractorCap -> contractorCap.setSpiritualForm(true));
            TensuraEPCapability.sync((LivingEntity)sp);
            TensuraPlayerCapability.sync((Player)sp);
        }
        ContractLedger ledger = ContractLedger.get(srv);
        ledger.setStatus(contractId, ContractLedger.Status.DISSOLVED);
        if (contractor != null) {
            MysticismPlayerCapability.getFrom(contractor).ifPresent(c -> {
                c.dissolveActiveContract();
                this.removeMagic(element, contractor, contractee);
                MysticismNetwork.sendTo(new DissolveActiveContractPacket(), (LivingEntity)contractor);
            });
        }
        if (!srv.f_46443_) {
            MysticismNetwork.sendTo(new DissolveContractPacket(contract), (LivingEntity)contractee);
        }
        contract.invalidate();
        MysticismPlayerCapability.sync(contractee);
        MysticismPlayerCapability.sync(contractor);
        return true;
    }

    private void removeMagic(MagicElemental contractorElement, Player contractor, Player contractee) {
        int tier = this.spiritLevel(contractor);
        if (contractee instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)contractee;
            ContractMagicTable.revoke(sp, contractorElement, tier);
        }
    }

    @Override
    public void dissolveActiveContract() {
        this.setActiveContract(null);
        this.setSummonStatus(false);
    }

    @Override
    public boolean cancelPendingContract(Contract contract) {
        boolean isRemoved = this.pendingContracts.remove(contract);
        if (isRemoved) {
            contract.invalidate();
        }
        return isRemoved;
    }

    @Override
    public Contract getPendingContractById(int contractId) {
        for (Contract contract : this.pendingContracts) {
            if (contract.getId() != contractId) continue;
            return contract;
        }
        return null;
    }

    @Override
    public boolean isSpirit(Player self) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)self);
        return playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ELEMENTAL_QUEEN)));
    }

    @Override
    public boolean getIgnoreSpectator() {
        return this.shouldIgnoreSpectator;
    }

    @Override
    public void setIgnoreSpectator(boolean value) {
        this.shouldIgnoreSpectator = value;
    }

    @Override
    public boolean getSummonStatus() {
        return this.isSummoned;
    }

    @Override
    public void setSummonStatus(boolean value) {
        this.isSummoned = value;
        Player owner = this.getOwner();
        if (this.isSpirit(owner)) {
            TensuraPlayerCapability.getFrom((Player)owner).ifPresent(cap -> cap.setSpiritualForm(value));
        }
    }

    public static void checkForFirstLogin(Player entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MysticismPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                if (TensuraPlayerCapability.getRace((LivingEntity)entity) == null && player.m_9236_().m_46469_().m_46207_(MysticismGamerules.MILIM_MODE)) {
                    MilimReincarnation.reincarnateAsMilim((Player)player);
                }
            });
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.element != null) {
            tag.m_128405_("element", this.element.ordinal());
        }
        tag.m_128405_("lightning", this.lightningStrikes);
        tag.m_128379_("isSpirit", this.isSpirit);
        tag.m_128379_("isSummoned", this.isSummoned);
        if (this.activeContract != null) {
            tag.m_128365_("activeContract", (Tag)this.activeContract.save());
        }
        ListTag pendingContractsList = new ListTag();
        for (Contract contract : this.pendingContracts) {
            pendingContractsList.add((Object)contract.save());
        }
        tag.m_128365_("pendingContracts", (Tag)pendingContractsList);
        ListTag acceptedContractsList = new ListTag();
        for (Contract contract : this.acceptedContracts.values()) {
            acceptedContractsList.add((Object)contract.save());
        }
        tag.m_128365_("acceptedContracts", (Tag)acceptedContractsList);
        tag.m_128405_("soulQuality", this.soulQuality);
        tag.m_128405_("currentUltimates", this.currentUltimates);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("element")) {
            this.element = MagicElemental.values()[nbt.m_128451_("element")];
        }
        this.lightningStrikes = nbt.m_128451_("lightning");
        this.isSpirit = nbt.m_128471_("isSpirit");
        this.isSummoned = nbt.m_128471_("isSummoned");
        if (nbt.m_128441_("activeContract")) {
            this.activeContract = Contract.load(nbt.m_128469_("activeContract"));
        }
        ListTag pendingContractsList = nbt.m_128437_("pendingContracts", 10);
        for (int i = 0; i < pendingContractsList.size(); ++i) {
            CompoundTag contractTag = pendingContractsList.m_128728_(i);
            Contract contract = Contract.load(contractTag);
            this.pendingContracts.add(contract);
        }
        ListTag acceptedContractsList = nbt.m_128437_("acceptedContracts", 10);
        for (int i = 0; i < acceptedContractsList.size(); ++i) {
            CompoundTag contractTag = acceptedContractsList.m_128728_(i);
            Contract contract = Contract.load(contractTag);
            MagicElemental element = contract.getElement();
            if (element == null) continue;
            this.acceptedContracts.put(element, contract);
        }
        this.soulQuality = nbt.m_128451_("soulQuality");
        this.currentUltimates = nbt.m_128451_("currentUltimates");
    }

    @Override
    public MagicElemental getElement() {
        return this.element;
    }

    public boolean isSpirit() {
        return this.isSpirit;
    }

    public boolean isShouldIgnoreSpectator() {
        return this.shouldIgnoreSpectator;
    }

    public boolean isSummoned() {
        return this.isSummoned;
    }

    @Override
    public void setElement(MagicElemental element) {
        this.element = element;
    }

    @Override
    public void setSpirit(boolean isSpirit) {
        this.isSpirit = isSpirit;
    }

    public void setShouldIgnoreSpectator(boolean shouldIgnoreSpectator) {
        this.shouldIgnoreSpectator = shouldIgnoreSpectator;
    }

    public void setSummoned(boolean isSummoned) {
        this.isSummoned = isSummoned;
    }

    @Override
    public int getLightningStrikes() {
        return this.lightningStrikes;
    }

    @Override
    public void setLightningStrikes(int lightningStrikes) {
        this.lightningStrikes = lightningStrikes;
    }
}

