/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.Memoires.trmysticism.client.models.EmptyModel;
import io.github.Memoires.trmysticism.client.renderers.ShadowSubordinateOverlayLayer;
import io.github.Memoires.trmysticism.entity.skill.ShadowSubordinateEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShadowSubordinateEntityRenderer
extends LivingEntityRenderer<ShadowSubordinateEntity, EmptyModel> {
    private final EntityRendererProvider.Context context;
    private LivingEntity cachedEntity = null;

    public ShadowSubordinateEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EmptyModel(), 0.0f);
        this.context = context;
        this.m_115326_(new ShadowSubordinateOverlayLayer(this));
    }

    public void render(ShadowSubordinateEntity shadowSubordinate, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        CompoundTag mobData = shadowSubordinate.getOriginalMobData();
        if (!mobData.m_128441_("id")) {
            super.m_7392_((LivingEntity)shadowSubordinate, entityYaw, partialTicks, matrixStack, buffer, packedLight);
            return;
        }
        if (this.cachedEntity == null || !EntityType.m_20613_((EntityType)this.cachedEntity.m_6095_()).toString().equals(mobData.m_128461_("id"))) {
            this.cachedEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)shadowSubordinate.f_19853_, entity -> entity);
        }
        if (this.cachedEntity == null) {
            super.m_7392_((LivingEntity)shadowSubordinate, entityYaw, partialTicks, matrixStack, buffer, packedLight);
            return;
        }
        float interpolatedYRot = shadowSubordinate.f_19859_ + (shadowSubordinate.m_146908_() - shadowSubordinate.f_19859_) * partialTicks;
        float interpolatedXRot = shadowSubordinate.f_19860_ + (shadowSubordinate.m_146909_() - shadowSubordinate.f_19860_) * partialTicks;
        this.cachedEntity.m_146922_(interpolatedYRot);
        this.cachedEntity.m_146926_(interpolatedXRot);
        this.cachedEntity.f_20883_ = shadowSubordinate.f_20883_;
        this.cachedEntity.f_20884_ = shadowSubordinate.f_20884_;
        this.cachedEntity.f_20885_ = shadowSubordinate.f_20885_;
        this.cachedEntity.f_20886_ = shadowSubordinate.f_20886_;
        this.cachedEntity.m_6034_(shadowSubordinate.m_20185_(), shadowSubordinate.m_20186_(), shadowSubordinate.m_20189_());
        EntityRenderer renderer = this.context.m_174022_().m_114382_((Entity)this.cachedEntity);
        if (renderer != null) {
            matrixStack.m_85836_();
            renderer.m_7392_((Entity)this.cachedEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
            matrixStack.m_85849_();
        }
        this.renderOverlayLayer(matrixStack, buffer, packedLight, shadowSubordinate);
    }

    private void renderOverlayLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ShadowSubordinateEntity shadowSubordinate) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)new ResourceLocation("trmysticism", "textures/entity/black.png")));
        EmptyModel model = (EmptyModel)this.m_7200_();
        model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 0.0f, 0.0f, 0.0f, 0.5f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ShadowSubordinateEntity entity) {
        return new ResourceLocation("trmysticism", "textures/entity/black.png");
    }
}

