/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.Memoires.trmysticism.entity.template.SpikeEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SpikeRenderer
extends EntityRenderer<SpikeEntity> {
    public static final ModelLayerLocation SPIKE = new ModelLayerLocation(new ResourceLocation("tensura", "spike"), "main");
    private final ModelPart spike;

    public SpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(SPIKE);
        this.spike = modelpart.m_171324_("spike");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition spike = partdefinition.m_171599_("spike", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -64.0f, 0.0f, 16.0f, 64.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        spike.m_171599_("side_spike", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -64.0f, 0.0f, 16.0f, 64.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)64);
    }

    public void render(SpikeEntity spike, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || !spike.m_20177_((Player)minecraft.f_91074_)) {
            poseStack.m_85836_();
            float radius = (float)Math.min(spike.getTickCount(), spike.getExtendingTick()) / (float)spike.getExtendingTick();
            poseStack.m_85841_(1.0f, radius * spike.getHeight() / 4.0f, 1.0f);
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(spike)));
            this.spike.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
            poseStack.m_85849_();
            super.m_7392_((Entity)spike, yaw, partialTicks, poseStack, bufferSource, light);
        }
    }

    public ResourceLocation getTextureLocation(SpikeEntity instance) {
        return new ResourceLocation("trmysticism", "textures/entity/darkness_spike.png");
    }
}

