/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.client.screen;

import com.github.manasmods.manascore.api.client.gui.FontRenderHelper;
import com.github.manasmods.manascore.api.client.gui.widget.ImagePredicateButton;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.client.TensuraGUIHelper;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.Memoires.trmysticism.menu.VicMenu;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2server.RequestSkillTrueCopyPacket;
import io.github.Memoires.trmysticism.network.play2server.RequestSkillTruePastePacket;
import io.github.Memoires.trmysticism.util.Cached;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class VicScreen
extends AbstractContainerScreen<VicMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tensura", "textures/gui/skill_creator/skill_creator.png");
    private static final ResourceLocation SKILL_BAR = new ResourceLocation("tensura", "textures/gui/skill_button.png");
    private static final ResourceLocation SCROLL_BAR = new ResourceLocation("tensura", "textures/gui/scroll_bar.png");
    private static final ResourceLocation GAIN_BUTTON = new ResourceLocation("tensura", "textures/gui/skill_creator/gain_button.png");
    public VicMenu containerId;
    public boolean isPaste;
    private Cached<List<ManasSkill>, String> filteredSkills;
    private Cached<List<ManasSkill>, String> copiedSkills;
    private ManasSkill selectedSkill = null;
    private boolean scrolling;
    private float scrollOffs;
    private int startIndex;
    private EditBox searchField;
    private final List<ManasSkill> skills;
    private final Player player;
    private final UUID targetUUID;

    public VicScreen(VicMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)pTitle.m_6881_().m_130940_(ChatFormatting.WHITE));
        this.f_97726_ = 233;
        this.f_97727_ = 140;
        this.player = pPlayerInventory.f_35978_;
        this.skills = ((VicMenu)this.f_97732_).getSkills().stream().map(skill -> (ManasSkill)SkillAPI.getSkillRegistry().getValue(skill)).toList();
        this.targetUUID = ((VicMenu)this.f_97732_).getTargetUUID();
        this.isPaste = ((VicMenu)this.f_97732_).getIsPaste();
    }

    protected void m_7856_() {
        Button.OnTooltip var10008;
        Button.OnPress var10007;
        super.m_7856_();
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.searchField = new EditBox(this.f_96547_, this.getGuiLeft() + 19, this.getGuiTop() + 27, 79, 9, (Component)Component.m_237119_());
        this.searchField.m_94182_(false);
        this.searchField.m_94151_(s -> {
            if (!s.isEmpty()) {
                this.scrollOffs = 0.0f;
                this.startIndex = 0;
            }
        });
        this.m_142416_((GuiEventListener)this.searchField);
        this.filteredSkills = new Cached(() -> {
            ArrayList<ManasSkill> filteredSkillList = new ArrayList<ManasSkill>(List.copyOf(this.skills));
            if (!this.searchField.m_94155_().isEmpty() && !this.searchField.m_94155_().isBlank()) {
                String filterValue = this.searchField.m_94155_().toLowerCase();
                filteredSkillList.removeIf(skill -> {
                    if (skill.getName() == null) {
                        return true;
                    }
                    return !skill.getName().getString().toLowerCase().contains(filterValue);
                });
            }
            return filteredSkillList;
        }, info -> {
            if (info.lastCallbackReference == null || !((String)info.lastCallbackReference).equals(this.searchField.m_94155_())) {
                info.lastCallbackReference = this.searchField.m_94155_();
                info.needsUpdate = true;
            }
            return info;
        });
        int var10002 = this.getGuiLeft() + 162;
        int var10003 = this.getGuiTop() + 116;
        ResourceLocation var10006 = GAIN_BUTTON;
        if (!this.isPaste) {
            var10007 = pButton -> MysticismNetwork.sendToServer(new RequestSkillTrueCopyPacket(SkillUtils.getSkillId((ManasSkill)this.selectedSkill)));
            var10008 = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_copy"), x, y);
        } else if (this.isPaste) {
            var10007 = pButton -> MysticismNetwork.sendToServer(new RequestSkillTruePastePacket(SkillUtils.getSkillId((ManasSkill)this.selectedSkill), this.targetUUID));
            var10008 = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_paste"), x, y);
        } else {
            var10007 = pButton -> MysticismNetwork.sendToServer(new RequestSkillTruePastePacket(SkillUtils.getSkillId((ManasSkill)this.selectedSkill), this.targetUUID));
            var10008 = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_paste"), x, y);
        }
        VicMenu vicMenu = (VicMenu)this.f_97732_;
        Objects.requireNonNull(vicMenu);
        ImagePredicateButton gainSkillButton = new ImagePredicateButton(var10002, var10003, 20, 20, var10006, var10007, var10008, vicMenu::check);
        this.m_142416_((GuiEventListener)gainSkillButton);
    }

    protected void m_7286_(PoseStack poseStack, float pPartialTick, int pX, int pY) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.isPaste) {
            TensuraGUIHelper.renderScaledCenteredXText((Font)this.f_96547_, (PoseStack)poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_copy"), (int)(this.getGuiLeft() + 3), (int)(this.getGuiTop() + 7), (int)112, (int)11, (Color)Color.LIGHT_GRAY, (boolean)false);
        } else if (this.isPaste) {
            TensuraGUIHelper.renderScaledCenteredXText((Font)this.f_96547_, (PoseStack)poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.true_paste"), (int)(this.getGuiLeft() + 3), (int)(this.getGuiTop() + 7), (int)112, (int)11, (Color)Color.LIGHT_GRAY, (boolean)false);
        } else {
            TensuraGUIHelper.renderScaledCenteredXText((Font)this.f_96547_, (PoseStack)poseStack, (Component)Component.m_237115_((String)"trmysticism.skill.mode.viciel.copy_bank"), (int)(this.getGuiLeft() + 3), (int)(this.getGuiTop() + 7), (int)112, (int)11, (Color)Color.LIGHT_GRAY, (boolean)false);
        }
        int k = (int)(78.0f * this.scrollOffs);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCROLL_BAR);
        VicScreen.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 98), (int)(this.f_97736_ + 43 + k), (float)0.0f, (float)(this.isScrollBarActive() ? 13.0f : 0.0f), (int)10, (int)13, (int)10, (int)26);
        List<ManasSkill> filteredSkills = this.filteredSkills.getValue();
        int lastVisibleElementIndex = Math.min(this.startIndex + 7, filteredSkills.size());
        this.renderButtons(poseStack, pX, pY, lastVisibleElementIndex, filteredSkills);
        if (this.selectedSkill != null) {
            boolean hovering;
            ResourceLocation location = this.selectedSkill.getSkillIcon();
            if (location != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)location);
                VicScreen.m_93133_((PoseStack)poseStack, (int)(this.getGuiLeft() + 162), (int)(this.getGuiTop() + 9), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
            }
            Component description = this.selectedSkill.getSkillDescription();
            FontRenderHelper.renderScaledTextInArea((PoseStack)poseStack, (Font)this.f_96547_, (FormattedText)description, (float)(this.getGuiLeft() + 125), (float)(this.getGuiTop() + 46), (float)94.0f, (float)66.0f, (Color)Color.LIGHT_GRAY);
            boolean bl = hovering = pX > this.getGuiLeft() + 158 && pX < this.getGuiLeft() + 185 && pY > this.getGuiTop() + 5 && pY < this.getGuiTop() + 32;
            if (hovering && this.selectedSkill.getName() != null) {
                this.m_96602_(poseStack, (Component)this.selectedSkill.getName(), pX, pY);
            }
        }
    }

    private void renderButtons(PoseStack pPoseStack, int pMouseX, int pMouseY, int pLastVisibleElementIndex, List<ManasSkill> list) {
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < list.size(); ++i) {
            boolean hovering;
            int x = this.getGuiLeft() + 6;
            int y = this.getGuiTop() + 43 + (i - this.startIndex) * 13;
            int offset = 0;
            boolean bl = hovering = pMouseX >= x && pMouseY >= y && pMouseX < x + 89 && pMouseY < y + 13;
            if (hovering) {
                offset = 13;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)SKILL_BAR);
            VicScreen.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)0.0f, (float)offset, (int)89, (int)13, (int)89, (int)26);
            ManasSkill manasSkill = list.get(i);
            Skill.SkillType skillType = Skill.SkillType.COMMON;
            if (manasSkill instanceof Skill) {
                Skill skill = (Skill)manasSkill;
                skillType = skill.getType();
            }
            MutableComponent name = this.skillName(manasSkill).m_130940_(skillType.getChatFormatting());
            TensuraGUIHelper.renderScaledShadowText((PoseStack)pPoseStack, (Font)this.f_96547_, (FormattedText)TensuraGUIHelper.shortenTextComponent((Component)name, (int)14), (float)(this.getGuiLeft() + 11), (float)(this.getGuiTop() + 46 + (i - this.startIndex) * 13), (float)85.0f, (float)13.0f, (int)Color.WHITE.getRGB(), (float)2.0f, (float)0.01f);
            if (!hovering) continue;
            this.m_96602_(pPoseStack, (Component)name, pMouseX, pMouseY);
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        super.m_7025_(pPoseStack, pX, pY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchField.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.searchField.m_93696_() && this.searchField.m_94213_() && pKeyCode != 256) {
            return true;
        }
        return this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode)) || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        this.scrolling = false;
        List<ManasSkill> skills = this.filteredSkills.getValue();
        int lastDisplayedIndex = Math.min(this.startIndex + 7, skills.size());
        for (int i = this.startIndex; i < lastDisplayedIndex; ++i) {
            int x = this.getGuiLeft() + 6;
            int y = this.getGuiTop() + 43 + (i - this.startIndex) * 13;
            if (skills.size() <= i) break;
            if (!(pX >= (double)x) || !(pY >= (double)y) || !(pX < (double)(x + 89)) || !(pY < (double)(y + 13))) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.selectedSkill = skills.get(i);
            return true;
        }
        if (pX >= (double)(this.getGuiLeft() + 98) && pX < (double)(this.getGuiLeft() + 109) && pY >= (double)(this.getGuiTop() + 43) && pY < (double)(this.getGuiTop() + 135)) {
            this.scrolling = true;
        }
        return super.m_6375_(pX, pY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, Math.min(this.startIndex - (int)pDelta, this.filteredSkills.getValue().size() - 7));
        }
        return true;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.getGuiTop() + 43;
            int j = i + 91;
            this.scrollOffs = (float)((pMouseY - (double)i - 6.5) / (double)((float)(j - i) - 13.0f));
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private MutableComponent skillName(@Nullable ManasSkill skill) {
        return skill != null && skill.getName() != null ? skill.getName() : Component.m_237115_((String)"tensura.race.selection.skills.empty");
    }

    private boolean isScrollBarActive() {
        return this.filteredSkills.getValue().size() > 7;
    }

    private int getOffscreenRows() {
        return this.filteredSkills.getValue().size() - 7;
    }
}

