/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.command;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.PermissionHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.command.MysticismPermissions;
import io.github.Memoires.trmysticism.handlers.ContractHandler;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2client.OpenContractGUIPacket;
import io.github.Memoires.trmysticism.network.play2server.IntrinsicSkillsRequestPacket;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.util.ContractMagicTable;
import io.github.Memoires.trmysticism.world.ContractLedger;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MysticismCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mysticism").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"soulQuality").executes(context -> {
            ServerPlayer player = (ServerPlayer)((CommandSourceStack)context.getSource()).m_81373_();
            AtomicInteger soulQuality = new AtomicInteger();
            MysticismPlayerCapability.getFrom((Player)player).ifPresent(cap -> soulQuality.set(cap.getSoulQuality()));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"trmysticism.command.soul_quality.get", (Object[])new Object[]{player.m_7755_(), soulQuality}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            return 1;
        }))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(commandSource -> PermissionHelper.hasPermissionOrIsConsole((CommandSourceStack)commandSource, MysticismPermissions.PLAYER_EDIT_SOUL_OTHERS))).then(Commands.m_82127_((String)"soulQuality").executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            AtomicInteger soulQuality = new AtomicInteger();
            MysticismPlayerCapability.getFrom((Player)player).ifPresent(cap -> soulQuality.set(cap.getSoulQuality()));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"trmysticism.command.soul_quality.get", (Object[])new Object[]{player.m_7755_(), soulQuality}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").requires(commandSource -> PermissionHelper.hasPermissionOrIsConsole((CommandSourceStack)commandSource, MysticismPermissions.PLAYER_EDIT_SOUL_SELF))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(commandSource -> PermissionHelper.hasPermissionOrIsConsole((CommandSourceStack)commandSource, MysticismPermissions.PLAYER_EDIT_SOUL_OTHERS))).then(Commands.m_82127_((String)"soulQuality").then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            int newSoulQuality = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            MysticismPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setSoulQuality(newSoulQuality));
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"trmysticism.command.soul_quality.edit", (Object[])new Object[]{player.m_7755_(), newSoulQuality}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spirit").then(Commands.m_82127_((String)"forceDissolve").executes(context -> {
            ServerPlayer targetContractor = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            return MysticismCommand.doForceDissolve((CommandSourceStack)context.getSource(), targetContractor);
        }))).then(Commands.m_82127_((String)"rerollElement").executes(commandContext -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)commandContext, (String)"player");
            return MysticismCommand.doElementReroll((CommandSourceStack)commandContext.getSource(), player);
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spirit").then(Commands.m_82127_((String)"forceDissolve").executes(context -> {
            ServerPlayer contractor = (ServerPlayer)((CommandSourceStack)context.getSource()).m_81373_();
            return MysticismCommand.doForceDissolve((CommandSourceStack)context.getSource(), contractor);
        }))).then(Commands.m_82127_((String)"viewContract").then(Commands.m_82129_((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> MysticismCommand.executeViewContract((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"id")))))));
    }

    private static int doElementReroll(CommandSourceStack source, ServerPlayer player) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (playerRace != null && playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT))) {
            MagicElemental[] elements = MagicElemental.values();
            MagicElemental randomElement = elements[new Random().nextInt(elements.length)];
            ContractMagicTable.revokeAll(player);
            if (player.f_19853_.f_46443_) {
                MysticismNetwork.sendToServer(new IntrinsicSkillsRequestPacket(randomElement.getNamespace()));
            } else {
                source.m_81354_((Component)Component.m_237115_((String)"trmysticism.command.reroll_element.success").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
                ArrayList<TensuraSkill> skillList = new ArrayList<TensuraSkill>();
                MagicElemental element = MagicElemental.valueOf((String)randomElement.name());
                IntrinsicSkillsRequestPacket.assignElementAndSkills((Player)player, skillList, element);
                SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
                for (TensuraSkill skill : skillList) {
                    storage.learnSkill((ManasSkill)skill);
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                TensuraSkillCapability.sync((Player)player);
                MysticismPlayerCapability.sync((Player)player);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237115_((String)"trmysticism.command.reroll_element.failure").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        return 0;
    }

    private static int executeViewContract(CommandSourceStack source, int contractId) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        MysticismPlayerCapability.getFrom((Player)player).ifPresent(arg_0 -> MysticismCommand.lambda$executeViewContract$13(contractId, (Player)player, source, arg_0));
        return 1;
    }

    private static int doForceDissolve(CommandSourceStack source, ServerPlayer contractor) {
        MysticismPlayerCapability.getFrom((Player)contractor).ifPresent(cap -> {
            Contract active = cap.getActiveContract();
            if (active == null) {
                source.m_81352_((Component)Component.m_237110_((String)"trmysticism.command.force_dissolve.failure", (Object[])new Object[]{contractor.m_5446_()}).m_130940_(ChatFormatting.RED));
                return;
            }
            ServerLevel srv = contractor.m_9236_();
            ContractLedger ledger = ContractLedger.get(srv);
            ledger.setStatus(active.getId(), ContractLedger.Status.DISSOLVED);
            cap.dissolveContract(active);
            MysticismPlayerCapability.sync((Player)contractor);
            source.m_81354_((Component)Component.m_237110_((String)"trmysticism.command.force_dissolve.success", (Object[])new Object[]{contractor.m_5446_(), contractor.m_5446_()}).m_130940_(ChatFormatting.DARK_GREEN), false);
            ServerPlayer contractee = contractor.m_20194_().m_6846_().m_11259_(active.getContracteeUUID());
            if (contractee != null) {
                MysticismPlayerCapability.getFrom((Player)contractee).ifPresent(contracteeCap -> {
                    contracteeCap.getAcceptedContracts().entrySet().removeIf(en -> ((Contract)en.getValue()).getId() == active.getId());
                    ContractHandler.revokeGivenSkillsIfNeeded(contractee, active);
                    MysticismPlayerCapability.sync((Player)contractee);
                    contractee.m_5661_((Component)Component.m_237110_((String)"trmysticism.command.force_dissolve.success_other", (Object[])new Object[]{contractor.m_5446_()}).m_130940_(ChatFormatting.RED), false);
                });
            }
            active.invalidate();
        });
        return 1;
    }

    private static /* synthetic */ void lambda$executeViewContract$13(int contractId, Player player, CommandSourceStack source, IMysticismPlayerCapability cap) {
        Contract contract = cap.getPendingContractById(contractId);
        if (contract != null) {
            MysticismNetwork.sendTo(new OpenContractGUIPacket(contract), (LivingEntity)player);
        } else {
            source.m_81354_((Component)Component.m_237113_((String)("You do not have a pending contract with the ID " + String.valueOf(contractId))).m_130940_(ChatFormatting.RED), false);
        }
    }
}

