/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.data.repeater;

import io.github.Memoires.trmysticism.data.repeater.JumpTracker;
import io.github.Memoires.trmysticism.handlers.RepeaterHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PlayerActionFrame {
    public Vec3 position;
    public float yaw;
    public float pitch;
    public boolean attacked;
    public boolean jumped;
    public boolean sneaked;
    public ItemStack usedItem;
    public boolean firedProjectile;
    public Vec3 projectileDirection;

    public static PlayerActionFrame capture(Player player) {
        PlayerActionFrame frame = new PlayerActionFrame();
        frame.position = player.m_20182_();
        frame.yaw = player.m_146908_();
        frame.pitch = player.m_146909_();
        frame.attacked = player.f_20911_;
        frame.jumped = JumpTracker.didJump((ServerPlayer)player);
        frame.sneaked = player.m_6047_();
        frame.usedItem = player.m_21211_().m_41619_() ? ItemStack.f_41583_ : player.m_21211_().m_41777_();
        if (player.m_21205_().m_41720_() instanceof BowItem) {
            frame.firedProjectile = RepeaterHandler.didFire((ServerPlayer)player);
            if (frame.firedProjectile) {
                frame.projectileDirection = player.m_20154_();
            }
        }
        return frame;
    }

    public void playback(Player player) {
        if (this.attacked) {
            player.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.jumped) {
            player.m_6135_();
        }
        if (this.sneaked) {
            player.m_20260_(true);
        }
        if (!this.usedItem.m_41619_()) {
            player.m_6672_(InteractionHand.MAIN_HAND);
        }
        if (this.firedProjectile) {
            this.shootGhostProjectile(player, this.projectileDirection);
        }
    }

    private void shootGhostProjectile(Player player, Vec3 direction) {
        Arrow arrow = new Arrow(player.m_9236_(), (LivingEntity)player);
        arrow.m_6034_(player.m_20185_(), player.m_20188_() - (double)0.1f, player.m_20189_());
        arrow.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 3.0f, 1.0f);
        player.m_9236_().m_7967_((Entity)arrow);
    }
}

