/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.ai.DynamicMeleeAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.DynamicMeleeAttackAction;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.FLyingTamableEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.mojang.math.Vector3f;
import io.github.Memoires.trmysticism.entity.magic.DarknessSpikeEntity;
import io.github.Memoires.trmysticism.entity.projectile.ShadowBallProjectile;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ShadowImpEntity
extends FLyingTamableEntity
implements IAnimatable,
IElementalSpirit {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(ShadowImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONING_TICK = SynchedEntityData.m_135353_(ShadowImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.m_135353_(ShadowImpEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    private UUID angryAt = null;

    public ShadowImpEntity(EntityType<? extends ShadowImpEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 40;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22278_, 0.2).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CatAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FlyingFollowOwnerGoal((TamableAnimal)this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(7, (Goal)new FLyingTamableEntity.WalkGoal((FLyingTamableEntity)this, (FLyingTamableEntity)this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal((TensuraTamableEntity)this, (TensuraTamableEntity)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(5, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ShadowImpEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAngryAt(Object o) {
        if (!(o instanceof Player)) return false;
        Player player = (Player)o;
        if (this.angryAt == null) return false;
        if (!player.m_20148_().equals(this.angryAt)) return false;
        return true;
    }

    public void setAngryAt(Player player) {
        this.angryAt = player.m_20148_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("SummoningTick", this.getSummoningTick());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() == 0 || animation == 0) {
            this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
        }
    }

    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    public void setSummonerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public LivingEntity m_21826_() {
        return this.getSummonerUUID() != null ? null : super.m_21826_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        ShadowImpEntity imp;
        Entity var4;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_21824_() && (var4 = pSource.m_7639_()) instanceof ShadowImpEntity && !(imp = (ShadowImpEntity)var4).m_21824_()) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setAngryAt(player);
        }
        return super.m_6469_(pSource, pAmount *= this.getPhysicalAttackInput(pSource));
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean canSleep() {
        return !this.m_21525_();
    }

    public boolean shouldCountMotionBlock() {
        return false;
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.getSummonerUUID() != null) {
            if (entity instanceof IElementalSpirit) {
                IElementalSpirit spirit = (IElementalSpirit)entity;
                return Objects.equals(spirit.getSummonerUUID(), this.getSummonerUUID());
            }
            return Objects.equals(entity.m_20148_(), this.getSummonerUUID());
        }
        if (entity instanceof ShadowImpEntity) {
            ShadowImpEntity lion = (ShadowImpEntity)entity;
            return lion.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return this.m_7307_((Entity)pTarget) ? false : super.m_6779_(pTarget);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        int rate = (Integer)SpawnRateConfig.INSTANCE.wingedCatSpawnRate.get();
        if (this.m_9236_().m_46472_().equals((Object)Level.f_46430_)) {
            rate *= 2;
        }
        return SpawnRateConfig.rollSpawn((int)rate, (RandomSource)this.m_217043_(), (MobSpawnType)pSpawnReason);
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            target = this.m_5448_();
            if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 10) {
                if (target != null && target.m_20096_()) {
                    this.spawnEarthSpikeUnder(target);
                } else {
                    this.shadowBallAttack(0.1, false);
                }
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12442_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (!this.f_19853_.m_5776_()) {
            this.summoningTicking((TamableAnimal)this);
            target = this.m_5448_();
            if (target != null && this.m_6084_() && target.m_6084_() && this.m_20280_((Entity)target) > 3.0) {
                this.setFlying(true);
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return miscAnimation == 1 ? 30 : 20;
    }

    public void spawnEarthSpikeUnder(LivingEntity target) {
        DarknessSpikeEntity spike = new DarknessSpikeEntity(this.f_19853_, (LivingEntity)this);
        spike.setDamage((float)this.m_21133_(Attributes.f_22281_));
        spike.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        spike.setExtendingTick(10);
        this.f_19853_.m_7967_((Entity)spike);
    }

    public void shadowBallAttack(double multishot, boolean negativeAngle) {
        ShadowBallProjectile shadowBall = new ShadowBallProjectile(this.f_19853_, (LivingEntity)this);
        shadowBall.setInvis(false);
        shadowBall.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)((ManasSkill)ExtraSkills.DARKNESS_MANIPULATION.get())));
        float radius = 2.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        shadowBall.m_6034_(this.m_20185_() + extraX, this.m_20188_() - 0.5, this.m_20189_() + extraZ);
        if (multishot > 0.0) {
            int rot = negativeAngle ? -145 : 145;
            float yaw = this.m_146908_() * ((float)Math.PI / 180);
            float f3 = Mth.m_14031_((float)((float)((double)yaw + Math.toRadians(rot))));
            float f = -Mth.m_14089_((float)((float)((double)yaw + Math.toRadians(rot))));
            shadowBall.m_6034_(shadowBall.m_20185_() + (double)f3 * multishot, shadowBall.m_20186_(), shadowBall.m_20189_() + (double)f * multishot);
        }
        shadowBall.setDamage((float)this.m_21133_(Attributes.f_22281_));
        shadowBall.m_20242_(true);
        shadowBall.setSpiritAttack(true);
        Vector3f vector3f = new Vector3f(this.m_146895_() != null ? this.m_146895_().m_20252_(2.0f) : this.m_20252_(2.0f));
        shadowBall.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 1.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)shadowBall);
    }

    public boolean hasDarknessManipulation() {
        return SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.DARKNESS_MANIPULATION.get()).isPresent();
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.SPIRIT_FOOD);
    }

    public boolean isTamingFood(ItemStack pStack) {
        return pStack.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get());
    }

    public MagicElemental getElemental() {
        return MagicElemental.DARKNESS;
    }

    public SpiritualMagic.SpiritLevel getSpiritLevel() {
        return SpiritualMagic.SpiritLevel.MEDIUM;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.isTamingFood(itemstack);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (player.m_36341_()) {
                    this.commanding(player);
                } else if (!this.convertElementalCore((LivingEntity)this, player, hand, (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get()) && player.m_146895_() == null) {
                    this.m_21839_(false);
                    this.setWandering(false);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        } else if (this.isTamingFood(itemstack)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 7 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_6710_((LivingEntity)player);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
        this.setMiscAnimation(1);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (this.getSummoningTick() >= 0) {
            this.m_5907_();
        } else {
            super.m_6668_(pDamageSource);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (!((double)this.f_19796_.m_188501_() > 0.1)) {
            this.m_19998_((ItemLike)TensuraMobDropItems.ELEMENTAL_ESSENCE.get());
        }
    }

    public boolean m_20068_() {
        if (super.m_20068_()) {
            return true;
        }
        return this.m_6688_() != null && !this.m_20096_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215776_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_215763_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    public boolean isInFlyingPose() {
        if (!this.m_20096_() && !this.m_21525_()) {
            if (!this.m_9236_().m_8055_(this.m_20097_().m_7495_()).m_60767_().m_76336_()) {
                return false;
            }
            return !this.m_21825_() && !this.m_21827_();
        }
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isInFlyingPose()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && !this.m_21525_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.winged_cat.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.shadow_imp.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class CatAttackGoal
    extends DynamicMeleeAttackGoal {
        public final ShadowImpEntity serpent;

        public CatAttackGoal(ShadowImpEntity serpent) {
            super((PathfinderMob)serpent, List.of((self, target, goal) -> 1.0f));
            this.serpent = serpent;
        }

        public boolean m_8036_() {
            return this.serpent.m_21827_() ? false : super.m_8036_();
        }

        protected List<DynamicMeleeAttackAction> getActions() {
            ArrayList<DynamicMeleeAttackAction> list = new ArrayList<DynamicMeleeAttackAction>();
            list.add((self, target, goal) -> {
                float speed = 1.5f;
                double distanceSqr = self.m_20280_((Entity)target);
                if (distanceSqr > 400.0) {
                    speed = 2.0f;
                } else {
                    this.checkAndPerformAttack(distanceSqr);
                    self.m_21391_((Entity)target, 70.0f, 70.0f);
                }
                return speed;
            });
            return list;
        }

        protected void checkAndPerformAttack(double pDistToEnemySqr) {
            if (this.serpent.getMiscAnimation() == 0) {
                double attackRange;
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                double d = attackRange = randomAttack == 2 ? 900.0 : 9.0;
                if (pDistToEnemySqr <= attackRange) {
                    this.serpent.setMiscAnimation(randomAttack);
                    if (randomAttack == 1) {
                        this.serpent.m_21573_().m_26573_();
                    }
                }
            }
        }

        protected int randomAttack(double distance) {
            return distance >= 9.0 ? 2 : 3;
        }
    }
}

