/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.goals;

import io.github.Memoires.trmysticism.entity.skill.SentryEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ShootAtTargetGoal
extends Goal {
    private final SentryEntity sentry;
    private LivingEntity target;
    private int attackTime = 0;
    private int lookAtTargetTime = 0;
    private int shootAnimationDuration = 10;
    private int currentAnimationTime = 0;
    private static final double TARGET_ANGLE = 180.0;

    public ShootAtTargetGoal(SentryEntity sentryEntity) {
        this.sentry = sentryEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.sentry.m_5448_();
        return livingentity != null && livingentity.m_6084_();
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target != null && !this.sentry.m_21573_().m_26571_() || this.currentAnimationTime > 0;
    }

    public void m_8056_() {
        super.m_8056_();
        this.sentry.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.sentry.m_21561_(false);
        this.sentry.setShooting(false);
        this.target = null;
        this.attackTime = 0;
        this.lookAtTargetTime = 0;
        this.currentAnimationTime = 0;
    }

    public void m_8037_() {
        LivingEntity currentTarget;
        if (this.currentAnimationTime > 0) {
            --this.currentAnimationTime;
            if (this.currentAnimationTime == 0) {
                this.sentry.setShooting(false);
            }
        }
        if ((currentTarget = this.sentry.m_5448_()) == null) {
            return;
        }
        this.target = currentTarget;
        double distanceToTarget = this.sentry.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSeeTarget = this.sentry.m_21574_().m_148306_((Entity)this.target);
        this.lookAtTargetTime = canSeeTarget ? ++this.lookAtTargetTime : 0;
        if (distanceToTarget <= 1024.0) {
            double dx = this.target.m_20185_() - this.sentry.m_20185_();
            double dy = this.target.m_20186_() - this.sentry.m_20186_();
            double dz = this.target.m_20189_() - this.sentry.m_20189_();
            double distance = Math.sqrt(dx * dx + dz * dz);
            float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            float pitch = (float)(-Math.toDegrees(Math.atan2(dy, distance)));
            this.sentry.m_5616_(yaw);
            this.sentry.m_146926_(pitch);
        }
        if (--this.attackTime <= 0 && this.lookAtTargetTime >= 5 && canSeeTarget) {
            this.sentry.setShooting(true);
            this.currentAnimationTime = this.shootAnimationDuration;
            this.sentry.shootAt(currentTarget, (float)distanceToTarget);
            this.attackTime = this.sentry.getFireRate();
        }
    }
}

