/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.projectile;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ElementalArrowProjectile
extends TensuraProjectile {
    private DamageSource damageType;
    private static final EntityDataAccessor<ItemStack> SOURCE_ITEM = SynchedEntityData.m_135353_(ElementalArrowProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public ElementalArrowProjectile(EntityType<? extends ElementalArrowProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public ElementalArrowProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType)MysticismEntityTypes.ELEMENTAL_ARROW.get(), levelIn);
        this.m_5602_((Entity)shooter);
        this.setDamageType(this.damageType);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOURCE_ITEM, (Object)((KunaiItem)TensuraToolItems.KUNAI.get()).m_7968_());
    }

    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/light_arrow.png")};
    }

    public ItemStack getSourceItem() {
        return (ItemStack)this.f_19804_.m_135370_(SOURCE_ITEM);
    }

    public void setSourceItem(ItemStack pStack) {
        this.f_19804_.m_135381_(SOURCE_ITEM, (Object)pStack);
    }

    public boolean piercingBlock() {
        return true;
    }

    public boolean shouldDiscardInLava() {
        return false;
    }

    public boolean shouldDiscardInWater() {
        return false;
    }

    public void setDamageType(DamageSource damageType) {
        this.damageType = damageType;
    }

    protected void hitEntity(Entity entity) {
        if (entity != this.m_37282_()) {
            super.hitEntity(entity);
        }
    }

    protected void dealDamage(Entity target) {
        DamageSource damageSource;
        if (!(this.getDamage() <= 0.0f) && (damageSource = this.damageType) != null && target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost((DamageSource)damageSource, (double)this.getMpCost(), (ManasSkillInstance)this.getSkill()), this.getDamage())) {
            target.f_19802_ = 0;
        }
    }

    protected void playHitSound(SoundEvent sound, HitResult hitresult) {
        if (hitresult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
            super.playHitSound(sound, hitresult);
        }
    }

    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)ParticleTypes.f_123808_, (double)x, (double)y, (double)z, (int)15, (double)0.1, (double)0.1, (double)0.1, (double)0.1, (boolean)true);
    }

    public void flyingParticles() {
    }
}

