/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.projectile;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ShadowBallProjectile
extends TensuraProjectile
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ShadowBallProjectile(EntityType<? extends ShadowBallProjectile> entityType, Level level) {
        super(entityType, level);
        this.setSize(0.4f);
    }

    public ShadowBallProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType)MysticismEntityTypes.SHADOW_BALL.get(), levelIn);
        this.m_5602_((Entity)shooter);
        this.setSize(0.4f);
    }

    public String getMagic() {
        return "tensura.dark_attack";
    }

    public boolean shouldDiscardInWater() {
        return false;
    }

    public boolean shouldDiscardInLava() {
        return false;
    }

    public void setPosAndShoot(LivingEntity entity) {
        this.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0));
        this.shootFromRot(entity.m_20154_());
    }

    public void explosion(double x, double y, double z) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_PURPLE_LIGHTNING_SPARK.get()), (double)2.0);
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_((double)this.getEffectRange()), entityData -> this.m_37282_() == null || !entityData.m_7307_(this.m_37282_()) && !entityData.m_7306_(this.m_37282_()));
        if (!livingEntityList.isEmpty()) {
            for (LivingEntity target : livingEntityList) {
                DamageSource damagesource;
                if (!target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost((DamageSource)(damagesource = TensuraDamageSources.indirectElementalAttack((String)"tensura.dark_attack", (Entity)this, (Entity)this.m_37282_(), (boolean)true)), (double)this.getMpCost(), (ManasSkillInstance)this.getSkill()), 30.0f)) continue;
                if (this.getMobEffect() != null) {
                    target.m_7292_(this.getMobEffect());
                }
                target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 300, 1, false, false, false));
            }
        }
    }

    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)((ParticleOptions)TensuraParticles.DARK_PURPLE_LIGHTNING_SPARK.get()), (double)x, (double)y, (double)z, (int)10, (double)0.5, (double)0.5, (double)0.5, (double)0.1, (boolean)false);
    }

    public void flyingParticles() {
        this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.DARK_PURPLE_LIGHTNING_SPARK.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.model.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

