/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.projectile.skill;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.StoneShotProjectile;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.particles.MysticismParticles;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AntaeusBlueProjectile
extends TensuraProjectile
implements IAnimatable {
    private final Map<Entity, Integer> trackedFallingBlocks = new HashMap<Entity, Integer>();
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int power = 1;

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.antaeus_blue_projectile.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void setPower(int power) {
        this.power = Math.max(1, power);
    }

    public AntaeusBlueProjectile(EntityType<? extends AntaeusBlueProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public AntaeusBlueProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType)MysticismEntityTypes.ANTAEUS_BLUE.get(), levelIn);
        this.m_5602_((Entity)shooter);
    }

    public String getMagic() {
        return "tensura.gravity_attack";
    }

    public boolean shouldDiscardInWater() {
        return false;
    }

    public boolean shouldDiscardInLava() {
        return false;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_20077_() {
        return false;
    }

    public boolean piercingEntity() {
        return true;
    }

    public void setPosAndShoot(LivingEntity entity) {
        this.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0));
        this.shootFromRot(entity.m_20154_());
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        if (this.shouldGrief()) {
            SkillHelper.launchBlock((Entity)this, (Vec3)result.m_82450_(), (int)3, (int)1, (float)0.5f, (float)0.2f, blockState -> {
                if (this.f_19796_.m_188503_(3) != 1) {
                    return false;
                }
                return blockState.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY);
            }, blockPos -> true, (ManasSkillInstance)this.getSkill());
        }
        super.m_8060_(result);
    }

    protected void hitEntity(Entity entity) {
        super.hitEntity(entity);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity pLivingEntity = (LivingEntity)entity;
        StoneShotProjectile.breakTargetArmor((LivingEntity)pLivingEntity, (int)20);
    }

    public void applyEffectAround(double inflateRadius) {
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(inflateRadius), entityData -> this.m_37282_() == null || !entityData.m_7307_(this.m_37282_()) && !entityData.m_7306_(this.m_37282_()));
        if (livingEntityList.isEmpty()) {
            return;
        }
        for (LivingEntity target : livingEntityList) {
            DamageSource damagesource = TensuraDamageSources.indirectElementalAttack((String)this.getMagic(), (Entity)this, (Entity)this.m_37282_(), (double)(this.getMpCost() / 10.0), (ManasSkillInstance)this.getSkill(), (boolean)false);
            DamageSourceHelper.dealSplitElementalDamage((Entity)target, (DamageSource)damagesource, (float)0.9f, (float)(this.getDamage() / 10.0f));
            Vec3 vec3 = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20186_() - target.m_20186_(), this.m_20189_() - target.m_20189_());
            target.m_20256_(target.m_20184_().m_82549_(vec3.m_82490_((double)0.05f)));
        }
    }

    private void suckInFallingBlocks(double radius, double suctionForce) {
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_(radius), entity -> entity instanceof FallingBlockEntity || entity instanceof ItemEntity || entity instanceof PrimedTnt || entity instanceof ExperienceOrb);
        for (Entity entity2 : entities) {
            if (this.m_20191_().m_82381_(entity2.m_20191_())) {
                if (entity2 instanceof FallingBlockEntity) {
                    FallingBlockEntity fallingBlock = (FallingBlockEntity)entity2;
                    fallingBlock.f_31943_ = false;
                }
                entity2.m_146870_();
                continue;
            }
            Vec3 direction = this.m_20182_().m_82546_(entity2.m_20182_()).m_82541_().m_82490_(suctionForce);
            entity2.m_20256_(entity2.m_20184_().m_82549_(direction));
            entity2.f_19864_ = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        double scaledRadius = (double)this.power + 2.0;
        double suctionForce = (double)this.power / 10.0;
        if (TensuraGameRules.canSkillGrief((Level)this.f_19853_)) {
            if (this.f_19853_.m_46472_() == MysticismDimensions.FANTASY_WORLD) {
                return;
            }
            SkillHelper.launchBlock((Entity)this, (Vec3)this.m_20182_(), (int)((int)scaledRadius), (int)5, (float)0.3f, (float)((float)suctionForce), blockState -> !blockState.m_60795_() && blockState.m_60819_().m_76178_() && !blockState.m_60819_().m_76170_() && blockState.m_60800_((BlockGetter)this.f_19853_, BlockPos.f_121853_) >= 0.0f, pos -> true, (ManasSkillInstance)this.getSkill());
            List fallingBlocks = this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82400_(scaledRadius));
            for (Entity entity : fallingBlocks) {
                if (!(entity instanceof FallingBlockEntity)) continue;
                FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
                fallingBlock.f_31943_ = false;
                if (this.trackedFallingBlocks.containsKey(fallingBlock)) continue;
                this.trackedFallingBlocks.put((Entity)fallingBlock, this.f_19797_);
            }
        }
        this.removeExpiredFallingBlocks();
        this.suckInFallingBlocks(scaledRadius, suctionForce);
        this.applyEffectAround(scaledRadius);
    }

    private void removeExpiredFallingBlocks() {
        Iterator<Map.Entry<Entity, Integer>> iterator = this.trackedFallingBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity fallingBlock = entry.getKey();
            int spawnTick = entry.getValue();
            if (this.f_19797_ - spawnTick <= 40) continue;
            fallingBlock.m_146870_();
            iterator.remove();
        }
    }

    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)ParticleTypes.f_123813_, (double)x, (double)y, (double)z, (int)1, (double)0.12, (double)0.12, (double)0.12, (double)0.15, (boolean)false);
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)ParticleTypes.f_123747_, (double)x, (double)y, (double)z, (int)3, (double)0.12, (double)0.12, (double)0.12, (double)0.15, (boolean)false);
        TensuraParticleHelper.spawnServerParticles((Level)this.f_19853_, (ParticleOptions)((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get()), (double)x, (double)y, (double)z, (int)10, (double)0.5, (double)0.5, (double)0.5, (double)0.1, (boolean)false);
    }

    public void flyingParticles() {
        if ((double)this.f_19796_.m_188501_() <= 0.8) {
            double dx = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dy = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dz = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double x = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double y = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double z = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            this.f_19853_.m_7106_((ParticleOptions)MysticismParticles.DARK_BLUE_LIGHTNING_SPARK.get(), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, dx, dy, dz);
        }
    }

    public int getPower() {
        return this.power;
    }
}

