/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.projectile.skill;

import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.util.damage.TensuraIndirectEntityDamageSource;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SentryMissileProjectile
extends TensuraProjectile
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> EXPLODED = SynchedEntityData.m_135353_(SentryMissileProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean rotationFixed = false;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SentryMissileProjectile(EntityType<? extends SentryMissileProjectile> entityType, Level level) {
        super(entityType, level);
        this.explosionRadius = 1.0f;
    }

    public SentryMissileProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType)MysticismEntityTypes.SENTRY_MISSILE.get(), levelIn);
        this.m_5602_((Entity)shooter);
        Vec3 direction = shooter.m_20154_().m_82541_().m_82490_(1.5);
        this.m_20256_(direction);
    }

    protected boolean m_5603_(Entity entity) {
        return entity != this.m_37282_() && super.m_5603_(entity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EXPLODED, (Object)false);
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && !((Boolean)this.f_19804_.m_135370_(EXPLODED)).booleanValue()) {
            this.f_19804_.m_135381_(EXPLODED, (Object)true);
            this.explosion(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        super.m_6532_(result);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        this.f_19804_.m_135381_(EXPLODED, (Object)true);
        TensuraIndirectEntityDamageSource damageSource = new TensuraIndirectEntityDamageSource("magic", (Entity)this, this.m_37282_());
        this.explosion(this.m_20185_(), this.m_20186_(), this.m_20189_());
        entity.m_6469_((DamageSource)damageSource, 305.0f);
    }

    public void explosion(double x, double y, double z) {
        if (!(this.getExplosionRadius() <= 0.0f)) {
            boolean mobGrief = this.shouldGrief();
            boolean fire = mobGrief && this.burnTicks > 0;
            this.f_19853_.m_46518_(this.m_37282_(), x, y, z, this.getExplosionRadius(), fire, Explosion.BlockInteraction.NONE);
        }
    }

    public void shootFromRot(Vec3 rotation) {
        this.m_20256_(rotation.m_82490_((double)this.getSpeed()));
        this.setInitialRotation(rotation);
    }

    public void setInitialRotation(Vec3 rotation) {
        if (!this.rotationFixed) {
            this.setRotation(rotation, true);
            this.rotationFixed = true;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickHandler();
        if (this.f_19853_.m_5776_()) {
            this.flyingParticles();
        } else if (this.shouldRemove()) {
            this.m_146870_();
        }
        if (this.rotationFixed) {
            return;
        }
    }

    protected void m_37283_() {
        if (!this.rotationFixed) {
            Vec3 vec3 = this.m_20184_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 114.591552734375));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)vec3.m_165924_()) * 114.591552734375));
            this.m_146926_(SentryMissileProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(SentryMissileProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        }
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

