/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.projectile.skill;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class SentryProjectile
extends TensuraProjectile {
    @Nullable
    protected DamageSource damageSource;
    @Nullable
    protected Entity target;

    public SentryProjectile(EntityType<? extends SentryProjectile> entityType, Level level) {
        super(entityType, level);
        this.setSize(0.25f);
    }

    public SentryProjectile(Level worldIn, LivingEntity shooter, boolean right) {
        super((EntityType)MysticismEntityTypes.SENTRY_PROJECTILE.get(), worldIn);
        this.m_5602_((Entity)shooter);
        this.setSize(0.25f);
        float rot = shooter.f_20885_ + (float)(right ? 60 : -60);
        this.m_6034_(shooter.m_20185_() - (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14031_((float)(rot * ((float)Math.PI / 180))), shooter.m_20188_() - (double)0.2f, shooter.m_20189_() + (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14089_((float)(rot * ((float)Math.PI / 180))));
    }

    public boolean shouldDiscardInWater() {
        return false;
    }

    public boolean shouldDiscardInLava() {
        return false;
    }

    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("trmysticism", "textures/entity/sentry_shot.png")};
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (this.target != null) {
            this.hitEntity(this.target);
            this.f_19853_.m_214171_(GameEvent.f_157777_, this.target.m_20182_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
            this.m_146870_();
        }
    }

    public Optional<SoundEvent> hitSound() {
        return Optional.empty();
    }

    protected void dealDamage(Entity target) {
        if (!(this.damage <= 0.0f) && target != this.m_37282_()) {
            DamageSource source = TensuraDamageSources.shot((Projectile)this, (Entity)this.m_37282_());
            if (this.damageSource != null) {
                source = this.damageSource;
            }
            if (!target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost((DamageSource)source, (double)this.getMpCost(), (ManasSkillInstance)this.getSkill()), this.getDamage())) {
                this.m_146870_();
            }
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public void hitParticles(double x, double y, double z) {
    }

    public void flyingParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_().m_82490_(2.0));
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public void setDamageSource(@Nullable DamageSource damageSource) {
        this.damageSource = damageSource;
    }

    @Nullable
    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable Entity target) {
        this.target = target;
    }
}

