/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import io.github.Memoires.trmysticism.entity.skill.BubbleShieldBarrierPartEntity;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BubbleShieldBarrierEntity
extends BarrierEntity
implements IAnimatable {
    private static final int DEFAULT_DURATION = 300;
    private static final float DEFAULT_HEALTH = 100.0f;
    private static final float DEFAULT_RADIUS = 3.0f;
    private static final float DEFAULT_HEIGHT = -2.3f;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public BubbleShieldBarrierEntity(EntityType<? extends BubbleShieldBarrierEntity> type, Level level) {
        super(type, level);
        this.setLife(300);
        this.setHealth(100.0f);
        this.setRadius(3.0f);
        this.setHeight(-2.3f);
        this.parts[0] = new BubbleShieldBarrierPartEntity(this, "Up", Direction.UP);
        this.parts[1] = new BubbleShieldBarrierPartEntity(this, "Down", Direction.DOWN);
        this.parts[2] = new BubbleShieldBarrierPartEntity(this, "North", Direction.NORTH);
        this.parts[3] = new BubbleShieldBarrierPartEntity(this, "East", Direction.EAST);
        this.parts[4] = new BubbleShieldBarrierPartEntity(this, "South", Direction.SOUTH);
        this.parts[5] = new BubbleShieldBarrierPartEntity(this, "West", Direction.WEST);
    }

    public static BubbleShieldBarrierEntity create(Level level, LivingEntity owner) {
        BubbleShieldBarrierEntity shield = new BubbleShieldBarrierEntity((EntityType<? extends BubbleShieldBarrierEntity>)((EntityType)MysticismEntityTypes.BUBBLE_SHIELD.get()), level);
        shield.m_5602_((Entity)owner);
        return shield;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isDamageFromInside(source)) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    private boolean isDamageFromInside(DamageSource source) {
        Entity sourceEntity = source.m_7640_();
        if (sourceEntity != null) {
            return this.m_20191_().m_82390_(sourceEntity.m_20182_());
        }
        return false;
    }

    public boolean canWalkThrough(Entity entity) {
        Entity owner = this.m_37282_();
        return owner != null && (entity == owner || entity.m_7307_(owner));
    }

    public AABB getAffectedArea() {
        return new AABB(this.m_20185_() - (double)this.getRadius(), this.m_20186_(), this.m_20189_() - (double)this.getRadius(), this.m_20185_() + (double)this.getRadius(), this.m_20186_() + (double)(this.getRadius() * 2.0f) + (double)this.getHeight(), this.m_20189_() + (double)this.getRadius());
    }

    public void spawnParticle() {
        for (int i = 0; i < 5; ++i) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.getRadius() * 2.0;
            double y = this.m_20186_() + this.f_19796_.m_188500_() * (double)(this.getRadius() * 2.0f + this.getHeight());
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.getRadius() * 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, (this.f_19796_.m_188500_() - 0.5) * 0.1, this.f_19796_.m_188500_() * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isMultipartEntity()) {
            for (BarrierPart part : this.parts) {
                part.directionPosition();
                part.directionBoundingBox();
            }
        }
        if (this.f_19797_ % 100 == 0) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11774_, this.m_5720_(), 0.5f, 1.0f);
        }
    }

    public static void spawnBubbleShield(LivingEntity owner) {
        if (owner == null || owner.f_19853_.m_5776_()) {
            return;
        }
        Level level = owner.f_19853_;
        BubbleShieldBarrierEntity shield = BubbleShieldBarrierEntity.create(level, owner);
        shield.m_146884_(owner.m_20182_());
        level.m_7967_((Entity)shield);
        level.m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)MysticismSoundEvents.ENGINEER_SHIELD_DEPLOY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        owner.m_21011_(InteractionHand.MAIN_HAND, true);
        level.m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_11776_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

