/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DispenserEntity
extends TensuraTamableEntity
implements IAnimatable {
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID;
    private static final EntityDataAccessor<Integer> SUMMONING_TICK;
    private static final EntityDataAccessor<Integer> DISPENSER_LEVEL;
    private static final EntityDataAccessor<Integer> PLAYER_PROXIMITY_TIME;
    private static final EntityDataAccessor<Boolean> IS_BEING_PLACED;
    protected static final AnimationBuilder BEING_PLACED;
    private static final HashMap<UUID, ArrayList<DispenserEntity>> playerDispensers;
    private static final HashMap<DispenserEntity, Long> DispenserCreationTimes;
    public static final int LEVEL_2_PROXIMITY_TIME = 2400;
    public static final int LEVEL_3_PROXIMITY_TIME = 6000;
    public static final float[] DISPENSER_MP_AND_AP_REGENERATION;
    public static final int[] FEED_AMOUNT;
    private UUID ownerUUID;
    private final long creationTime;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int regenTickCounter = 0;

    public DispenserEntity(EntityType<? extends TensuraTamableEntity> entityType, Level level) {
        super(entityType, level);
        this.creationTime = System.currentTimeMillis();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DISPENSER_LEVEL, (Object)1);
        this.f_19804_.m_135372_(PLAYER_PROXIMITY_TIME, (Object)0);
        this.f_19804_.m_135372_(IS_BEING_PLACED, (Object)true);
    }

    public boolean isBeingPlaced() {
        return (Boolean)this.f_19804_.m_135370_(IS_BEING_PLACED);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        LivingEntity owner = this.m_21826_();
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22276_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22281_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22284_);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_MAGICULE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_AURA);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.BARRIER);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.SIZE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH);
        this.m_21153_((float)this.m_21204_().m_22181_(Attributes.f_22276_));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void copyAttributeFromOwner(LivingEntity owner, Supplier<Attribute> attributeSupplier) {
        Attribute attribute = attributeSupplier.get();
        if (owner == null) {
            return;
        }
        boolean ownerHas = owner.m_21204_().m_22171_(attribute);
        boolean selfHas = this.m_21204_().m_22171_(attribute);
        if (ownerHas && selfHas) {
            double ownerValue = owner.m_21051_(attribute).m_22135_();
            this.m_21051_(attribute).m_22100_(ownerValue);
        }
    }

    public void setOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
        this.setDispenserLevel(compound.m_128451_("DispenserLevel"));
        this.setPlayerProximityTime(compound.m_128451_("PlayerProximityTime"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("SummoningTick", this.getSummoningTick());
        compound.m_128405_("DispenserLevel", this.getDispenserLevel());
        compound.m_128405_("PlayerProximityTime", this.getPlayerProximityTime());
    }

    public boolean m_6094_() {
        return false;
    }

    private boolean isAllied(LivingEntity entity) {
        Player owner = (Player)this.m_21826_();
        return owner != null && (entity == owner || entity.m_7307_((Entity)owner));
    }

    private void healNearbyAllies() {
        AABB area = new AABB(this.m_20183_()).m_82400_(5.0);
        List entities = this.f_19853_.m_45976_(LivingEntity.class, area);
        float baseRegeneration = DISPENSER_MP_AND_AP_REGENERATION[Math.min(this.getDispenserLevel(), DISPENSER_MP_AND_AP_REGENERATION.length - 1)];
        int foodAmount = FEED_AMOUNT[Math.min(this.getDispenserLevel(), FEED_AMOUNT.length - 1)];
        for (LivingEntity entity : entities) {
            if (entity == this || !this.isAllied(entity)) continue;
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MysticismSoundEvents.ENGINEER_HEAL_DISPENSE.get(), SoundSource.NEUTRAL, 0.8f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.healBasedOnLevel(entity, this.getDispenserLevel());
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.m_36324_().m_38705_(Math.min(player.m_36324_().m_38702_() + foodAmount, 20));
            if (this.getDispenserLevel() >= 3) {
                player.m_36324_().m_38717_(Math.min(player.m_36324_().m_38722_() + 1.0f, 20.0f));
            }
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                double regenAmount;
                double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                double maxAP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                if (cap.getMagicule() < maxMP) {
                    regenAmount = maxMP * (double)baseRegeneration;
                    double newMana = cap.getMagicule() + regenAmount;
                    cap.setMagicule(Math.min(newMana, maxMP));
                }
                if (cap.getAura() < maxAP) {
                    regenAmount = maxAP * (double)baseRegeneration;
                    double newAura = cap.getAura() + regenAmount;
                    cap.setAura(Math.min(newAura, maxAP));
                }
                TensuraPlayerCapability.sync((Player)player);
            });
        }
    }

    private void healBasedOnLevel(LivingEntity entity, int dispenserLevel) {
        double maxHP = entity.m_21233_();
        switch (dispenserLevel) {
            case 1: {
                entity.m_5634_((float)(maxHP * 0.01) + 2.0f);
                break;
            }
            case 2: {
                entity.m_5634_((float)(maxHP * 0.03) + 5.0f);
                break;
            }
            case 3: {
                entity.m_5634_((float)(maxHP * 0.05) + 10.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public int getDispenserLevel() {
        return (Integer)this.f_19804_.m_135370_(DISPENSER_LEVEL);
    }

    public void setDispenserLevel(int level) {
        this.f_19804_.m_135381_(DISPENSER_LEVEL, (Object)level);
    }

    public int getPlayerProximityTime() {
        return (Integer)this.f_19804_.m_135370_(PLAYER_PROXIMITY_TIME);
    }

    public void setPlayerProximityTime(int time) {
        this.f_19804_.m_135381_(PLAYER_PROXIMITY_TIME, (Object)time);
    }

    public void setDispenserLevel() {
        int proximityTime = this.getPlayerProximityTime();
        int newLevel = proximityTime >= 6000 ? 3 : (proximityTime >= 2400 ? 2 : 1);
        if (!this.m_9236_().f_46443_ && newLevel != this.getDispenserLevel()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            LivingEntity livingEntity = this.m_21826_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.engineer.dispenser_evolved", (Object[])new Object[]{newLevel}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            this.f_19804_.m_135381_(DISPENSER_LEVEL, (Object)newLevel);
        }
    }

    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    public void setSummonerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(uuid));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "beingPlaced", 5.0f, this::shootingController));
    }

    protected <E extends DispenserEntity> PlayState shootingController(AnimationEvent<E> event) {
        if (this.isBeingPlaced()) {
            event.getController().setAnimation(BEING_PLACED);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ > 30 && ((Boolean)this.f_19804_.m_135370_(IS_BEING_PLACED)).booleanValue()) {
                this.f_19804_.m_135381_(IS_BEING_PLACED, (Object)false);
            }
            ++this.regenTickCounter;
            if (this.getDispenserLevel() < 3 && this.regenTickCounter >= 100) {
                this.healNearbyAllies();
                this.regenTickCounter = 0;
            } else if (this.getDispenserLevel() >= 3 && this.regenTickCounter >= 60) {
                this.healNearbyAllies();
                this.regenTickCounter = 0;
            }
        }
        if (this.m_21826_() != null) {
            double maxDistance;
            double distanceToOwner;
            UUID ownerUUID = this.m_21826_().m_20148_();
            playerDispensers.computeIfAbsent(ownerUUID, k -> new ArrayList());
            if (!playerDispensers.get(ownerUUID).contains((Object)this)) {
                playerDispensers.get(ownerUUID).add(this);
            }
            if (playerDispensers.get(ownerUUID).size() > 1) {
                playerDispensers.get(ownerUUID).sort(Comparator.comparingLong(DispenserEntity::getCreationTime));
                DispenserEntity oldestDispenser = playerDispensers.get(ownerUUID).get(0);
                double x = oldestDispenser.m_20185_();
                double y = oldestDispenser.m_20186_();
                double z = oldestDispenser.m_20189_();
                if (oldestDispenser.f_19853_ != null) {
                    oldestDispenser.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1.0, 1.0, 1.0);
                }
                playerDispensers.get(ownerUUID).remove(0);
                oldestDispenser.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if ((distanceToOwner = this.m_20275_(this.m_21826_().m_20185_(), this.m_21826_().m_20186_(), this.m_21826_().m_20189_())) <= (maxDistance = 10.0) * maxDistance) {
                int proximityTime = this.getPlayerProximityTime();
                this.setPlayerProximityTime(proximityTime + 1);
            } else {
                int proximityTime = this.getPlayerProximityTime();
                if (proximityTime > 0) {
                    this.setPlayerProximityTime(proximityTime);
                }
            }
            this.setDispenserLevel();
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        UUID ownerUUID;
        if (this.m_21826_() != null && playerDispensers.containsKey(ownerUUID = this.m_21826_().m_20148_())) {
            playerDispensers.get(ownerUUID).remove((Object)this);
        }
        super.m_142687_(reason);
    }

    static {
        BEING_PLACED = new AnimationBuilder().addAnimation("deploy", Boolean.valueOf(true));
        playerDispensers = new HashMap();
        DispenserCreationTimes = new HashMap();
        DISPENSER_MP_AND_AP_REGENERATION = new float[]{0.0f, 0.01f, 0.03f, 0.03f};
        FEED_AMOUNT = new int[]{0, 1, 2, 3};
        SUMMONING_TICK = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SUMMONER_UUID = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        DISPENSER_LEVEL = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PLAYER_PROXIMITY_TIME = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        IS_BEING_PLACED = SynchedEntityData.m_135353_(DispenserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

