/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusBlueProjectile;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusPurpleProjectile;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntaeusRedProjectile;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class LimitlessBarrierEntity
extends Entity {
    private LivingEntity owner;
    private final Map<Projectile, Integer> projectilesToDespawn = new HashMap<Projectile, Integer>();

    public LimitlessBarrierEntity(EntityType<? extends LimitlessBarrierEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.m_6842_(true);
    }

    public LimitlessBarrierEntity(Level level, LivingEntity owner) {
        this((EntityType<? extends LimitlessBarrierEntity>)((EntityType)MysticismEntityTypes.LIMITLESS_BARRIER.get()), level);
        this.m_6034_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_());
        this.owner = owner;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.owner == null || !this.owner.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.teleportToOwner();
        this.applyBarrierEffects();
        this.haltProjectiles();
        this.handleDespawnTimers();
    }

    private void applyBarrierEffects() {
        double radius = 2.0 + (double)this.owner.m_20206_() / 2.0;
        AABB area = this.m_20191_().m_82400_(radius);
        this.f_19853_.m_6249_((Entity)this, area, entity -> entity instanceof Projectile).forEach(projectile -> {
            Vec3 motion = projectile.m_20184_().m_82490_(0.9);
            projectile.m_20256_(motion);
            if (motion.m_82556_() < 0.01) {
                projectile.m_20256_(Vec3.f_82478_);
            }
        });
        this.f_19853_.m_6249_((Entity)this, area, entity -> entity instanceof LivingEntity && entity != this.owner && !entity.m_7307_((Entity)this.owner)).forEach(entity -> {
            if (SkillUtils.hasSkill((Entity)entity, (ManasSkill)((ManasSkill)UltimateSkills.SUSANOO.get()))) {
                return;
            }
            Vec3 pushDirection = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.5);
            entity.m_20256_(pushDirection);
        });
    }

    private void teleportToOwner() {
        if (this.owner != null && this.owner.m_6084_()) {
            this.m_6021_(this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_());
        }
    }

    private void haltProjectiles() {
        double radius = 2.0;
        this.f_19853_.m_45976_(Projectile.class, this.m_20191_().m_82400_(radius)).stream().filter(this::shouldAffectProjectile).filter(projectile -> projectile.m_37282_() != this.owner).forEach(this::stopProjectile);
    }

    private void handleDespawnTimers() {
        Iterator<Map.Entry<Projectile, Integer>> iterator = this.projectilesToDespawn.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Projectile, Integer> entry = iterator.next();
            Projectile projectile = entry.getKey();
            int remainingTime = entry.getValue();
            if (remainingTime <= 0 || !projectile.m_6084_()) {
                projectile.m_146870_();
                iterator.remove();
                continue;
            }
            entry.setValue(remainingTime - 4);
        }
    }

    private boolean shouldAffectProjectile(Projectile projectile) {
        return !(projectile instanceof AntaeusBlueProjectile) && !(projectile instanceof AntaeusPurpleProjectile) && !(projectile instanceof AntaeusRedProjectile);
    }

    private void stopProjectile(Projectile projectile) {
        if (projectile instanceof AntaeusBlueProjectile || projectile instanceof AntaeusPurpleProjectile || projectile instanceof AntaeusRedProjectile) {
            return;
        }
        projectile.m_20334_(0.0, 0.0, 0.0);
        projectile.m_20242_(true);
        if (!this.projectilesToDespawn.containsKey(projectile)) {
            int despawnTime = 60 + this.f_19853_.f_46441_.m_188503_(41);
            this.projectilesToDespawn.put(projectile, despawnTime);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public LivingEntity getOwner() {
        return this.owner;
    }
}

