/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trmysticism.entity.goals.ShootAtTargetGoal;
import io.github.Memoires.trmysticism.entity.projectile.skill.SentryMissileProjectile;
import io.github.Memoires.trmysticism.entity.projectile.skill.SentryProjectile;
import io.github.Memoires.trmysticism.registry.sound.MysticismSoundEvents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SentryEntity
extends TensuraTamableEntity
implements IAnimatable {
    private static final HashMap<UUID, ArrayList<SentryEntity>> playerTurrets = new HashMap();
    private static final HashMap<SentryEntity, Long> turretCreationTimes = new HashMap();
    private UUID ownerUUID;
    private final long creationTime;
    protected static final AnimationBuilder SHOOTING = new AnimationBuilder().addAnimation("sentry5.shoot", Boolean.valueOf(true));
    protected static final AnimationBuilder SHOOT_LEVEL_2 = new AnimationBuilder().addAnimation("sentry5.shoot", Boolean.valueOf(true));
    protected static final AnimationBuilder SHOOT_LEVEL_3 = new AnimationBuilder().addAnimation("sentry5.shoot", Boolean.valueOf(true));
    protected static final AnimationBuilder EVOLVING = new AnimationBuilder().addAnimation("animation.model.new", Boolean.valueOf(true));
    protected static final AnimationBuilder BEING_PLACED = new AnimationBuilder().addAnimation("animation.model.new", Boolean.valueOf(true));
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID;
    private static final EntityDataAccessor<Integer> SUMMONING_TICK;
    private static final EntityDataAccessor<Integer> SENTRY_LEVEL;
    private static final EntityDataAccessor<Integer> PLAYER_PROXIMITY_TIME;
    private static final EntityDataAccessor<Boolean> IS_SHOOTING;
    private static final EntityDataAccessor<Boolean> IS_BEING_PLACED;
    private static final EntityDataAccessor<Boolean> IS_LEVELING_UP;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final int LEVEL_1_FIRE_RATE = 2;
    public static final int LEVEL_2_FIRE_RATE = 1;
    public static final int LEVEL_3_FIRE_RATE = 2;
    public static final float[] SENTRY_DAMAGE_BY_LEVEL;
    public static final int LEVEL_2_PROXIMITY_TIME = 2400;
    public static final int LEVEL_3_PROXIMITY_TIME = 6000;

    public SentryEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.creationTime = System.currentTimeMillis();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ShootAtTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> this.isEnemy((LivingEntity)entity)));
    }

    public void setOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
    }

    private boolean isEnemy(LivingEntity entity) {
        Player owner = (Player)this.m_21826_();
        return owner != null && entity != owner && !entity.m_7307_((Entity)owner);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
        this.f_19804_.m_135372_(SENTRY_LEVEL, (Object)1);
        this.f_19804_.m_135372_(PLAYER_PROXIMITY_TIME, (Object)0);
        this.f_19804_.m_135372_(IS_SHOOTING, (Object)false);
        this.f_19804_.m_135372_(IS_BEING_PLACED, (Object)true);
        this.f_19804_.m_135372_(IS_LEVELING_UP, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
        this.setSentryLevel(compound.m_128451_("SentryLevel"));
        this.setPlayerProximityTime(compound.m_128451_("PlayerProximityTime"));
        this.setShooting(compound.m_128471_("IsShooting"));
        this.setBeingPlaced(compound.m_128471_("BeingPlaced"));
        this.setLevelingUp(compound.m_128471_("IsLevelingUp"));
    }

    public boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.f_19804_.m_135381_(IS_SHOOTING, (Object)shooting);
    }

    public boolean isBeingPlaced() {
        return (Boolean)this.f_19804_.m_135370_(IS_BEING_PLACED);
    }

    public void setBeingPlaced(boolean placed) {
        this.f_19804_.m_135381_(IS_BEING_PLACED, (Object)placed);
    }

    public boolean isLevelingUp() {
        return (Boolean)this.f_19804_.m_135370_(IS_LEVELING_UP);
    }

    public void setLevelingUp(boolean levelingUp) {
        this.f_19804_.m_135381_(IS_LEVELING_UP, (Object)levelingUp);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("SummoningTick", this.getSummoningTick());
        compound.m_128405_("SentryLevel", this.getSentryLevel());
        compound.m_128405_("PlayerProximityTime", this.getPlayerProximityTime());
        compound.m_128379_("BeingPlaced", this.isBeingPlaced());
        compound.m_128379_("IsLevelingUp", this.isLevelingUp());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        LivingEntity owner = this.m_21826_();
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22276_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22281_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22284_);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_MAGICULE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_AURA);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.BARRIER);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.SIZE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH);
        this.m_21153_((float)this.m_21204_().m_22181_(Attributes.f_22276_));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void copyAttributeFromOwner(LivingEntity owner, Supplier<Attribute> attributeSupplier) {
        Attribute attribute = attributeSupplier.get();
        if (owner == null) {
            return;
        }
        boolean ownerHas = owner.m_21204_().m_22171_(attribute);
        boolean selfHas = this.m_21204_().m_22171_(attribute);
        if (ownerHas && selfHas) {
            double ownerValue = owner.m_21051_(attribute).m_22135_();
            this.m_21051_(attribute).m_22100_(ownerValue);
        }
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "Shooting", 5.0f, this::shootingController));
    }

    protected <E extends SentryEntity> PlayState shootingController(AnimationEvent<E> event) {
        if (this.isBeingPlaced()) {
            event.getController().setAnimation(BEING_PLACED);
            return PlayState.CONTINUE;
        }
        if (this.isLevelingUp()) {
            event.getController().setAnimation(EVOLVING);
            return PlayState.CONTINUE;
        }
        if (this.isShooting()) {
            switch (this.getSentryLevel()) {
                case 1: {
                    event.getController().setAnimation(SHOOTING);
                    break;
                }
                case 2: {
                    event.getController().setAnimation(SHOOT_LEVEL_2);
                    break;
                }
                case 3: {
                    event.getController().setAnimation(SHOOT_LEVEL_3);
                }
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_146922_(float yRot) {
        if (this.f_19803_) {
            super.m_146922_(yRot);
        }
    }

    public void m_5616_(float yHeadRot) {
        super.m_5616_(yHeadRot);
        this.f_20883_ = yHeadRot;
    }

    public void m_5618_(float yBodyRot) {
        super.m_5618_(yBodyRot);
        this.f_20885_ = yBodyRot;
    }

    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    public void setSummonerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(uuid));
    }

    public int getSentryLevel() {
        return (Integer)this.f_19804_.m_135370_(SENTRY_LEVEL);
    }

    public void setSentryLevel() {
        int proximityTime = this.getPlayerProximityTime();
        int newLevel = proximityTime >= 6000 ? 3 : (proximityTime >= 2400 ? 2 : 1);
        if (!this.m_9236_().f_46443_) {
            if (newLevel != this.getSentryLevel()) {
                this.setLevelingUp(true);
                this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
                LivingEntity livingEntity = this.m_21826_();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.engineer.turret_evolved", (Object[])new Object[]{newLevel}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                this.f_19804_.m_135381_(SENTRY_LEVEL, (Object)newLevel);
            } else {
                this.setLevelingUp(false);
            }
        }
    }

    public void setSentryLevel(int level) {
        this.f_19804_.m_135381_(SENTRY_LEVEL, (Object)level);
    }

    public int getPlayerProximityTime() {
        return (Integer)this.f_19804_.m_135370_(PLAYER_PROXIMITY_TIME);
    }

    public void setPlayerProximityTime(int time) {
        this.f_19804_.m_135381_(PLAYER_PROXIMITY_TIME, (Object)time);
    }

    public int getFireRate() {
        switch (this.getSentryLevel()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 2;
    }

    public void shootAt(LivingEntity target, float distanceFactor) {
        if (!this.f_19853_.f_46443_) {
            float baseDamage = SENTRY_DAMAGE_BY_LEVEL[Math.min(this.getSentryLevel(), SENTRY_DAMAGE_BY_LEVEL.length - 1)];
            if (this.getSentryLevel() < 3) {
                SentryProjectile sniperBullet = new SentryProjectile(this.f_19853_, (LivingEntity)this, true);
                double targetEyeY = target.m_20188_();
                double sentryFiringY = this.m_20186_() + 0.5;
                double dx = target.m_20185_() - this.m_20185_();
                double dz = target.m_20189_() - this.m_20189_();
                double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
                double dy = targetEyeY - sentryFiringY;
                double gravity = 0.0;
                double verticalVelocity = dy / horizontalDistance + gravity * horizontalDistance * 0.5;
                sniperBullet.m_6034_(this.m_20185_(), sentryFiringY, this.m_20189_());
                Vec3 direction = this.calculateDirectionToTarget(target);
                direction = direction.m_82490_(1.2);
                sniperBullet.m_20256_(direction);
                sniperBullet.setDamage((float)this.m_21133_(Attributes.f_22281_) + 5.0f + baseDamage);
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MysticismSoundEvents.ENGINEER_TURRET_SHOOT.get(), SoundSource.NEUTRAL, 0.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.f_19853_.m_7967_((Entity)sniperBullet);
            } else {
                double sentryFiringY = this.m_20186_() + 0.5;
                double dx = target.m_20185_() - this.m_20185_();
                double dy = target.m_20188_() - sentryFiringY;
                double dz = target.m_20189_() - this.m_20189_();
                if (this.getSentryLevel() == 3) {
                    if (this.m_217043_().m_188499_()) {
                        SentryProjectile sniperBullet = new SentryProjectile(this.f_19853_, (LivingEntity)this, true);
                        sniperBullet.m_6034_(this.m_20185_(), sentryFiringY, this.m_20189_());
                        Vec3 direction = this.calculateDirectionToTarget(target);
                        sniperBullet.m_20256_(direction);
                        sniperBullet.setDamage((float)this.m_21133_(Attributes.f_22281_) + 5.0f + baseDamage);
                        this.f_19853_.m_7967_((Entity)sniperBullet);
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MysticismSoundEvents.ENGINEER_TURRET_SHOOT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    } else {
                        SentryMissileProjectile missile = new SentryMissileProjectile(this.f_19853_, (LivingEntity)this);
                        missile.m_6034_(this.m_20185_(), sentryFiringY, this.m_20189_());
                        Vec3 direction = this.calculateDirectionToTarget(target);
                        missile.m_20256_(direction);
                        missile.explosion(target.m_20185_(), target.m_20186_(), target.m_20189_());
                        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)MysticismSoundEvents.ENGINEER_TURRET_MISSILE_SHOOT.get(), SoundSource.NEUTRAL, 1.0f, 0.8f + this.m_217043_().m_188501_() * 0.2f);
                        this.f_19853_.m_7967_((Entity)missile);
                    }
                }
            }
        }
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        this.f_20883_ = this.f_20885_;
        if (this.isBeingPlaced() && this.f_19797_ > 40) {
            this.setBeingPlaced(false);
        }
        if (this.m_21826_() != null) {
            UUID ownerUUID = this.m_21826_().m_20148_();
            playerTurrets.computeIfAbsent(ownerUUID, k -> new ArrayList());
            if (!playerTurrets.get(ownerUUID).contains((Object)this)) {
                playerTurrets.get(ownerUUID).add(this);
            }
            if (playerTurrets.get(ownerUUID).size() > 2) {
                playerTurrets.get(ownerUUID).sort(Comparator.comparingLong(SentryEntity::getCreationTime));
                SentryEntity oldestTurret = playerTurrets.get(ownerUUID).get(0);
                double x = oldestTurret.m_20185_();
                double y = oldestTurret.m_20186_();
                double z = oldestTurret.m_20189_();
                if (oldestTurret.f_19853_ != null) {
                    oldestTurret.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1.0, 1.0, 1.0);
                }
                playerTurrets.get(ownerUUID).remove(0);
                oldestTurret.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            double distanceToOwner = this.m_20275_(this.m_21826_().m_20185_(), this.m_21826_().m_20186_(), this.m_21826_().m_20189_());
            double maxDistance = 10.0;
            int proximityTime = this.getPlayerProximityTime();
            if (distanceToOwner <= maxDistance * maxDistance) {
                this.setPlayerProximityTime(proximityTime + 1);
            } else if (proximityTime > 0) {
                this.setPlayerProximityTime(proximityTime);
            }
            this.setSentryLevel();
        }
        if ((target = this.m_5448_()) != null) {
            this.updateTurretRotation(target);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        UUID ownerUUID;
        if (this.m_21826_() != null && playerTurrets.containsKey(ownerUUID = this.m_21826_().m_20148_())) {
            playerTurrets.get(ownerUUID).remove((Object)this);
        }
        super.m_142687_(reason);
    }

    private Vec3 calculateDirectionToTarget(LivingEntity target) {
        double dx = target.m_20185_() - this.m_20185_();
        double dy = target.m_20188_() - (this.m_20186_() + 0.5);
        double dz = target.m_20189_() - this.m_20189_();
        return new Vec3(dx, dy, dz).m_82541_();
    }

    private void updateTurretRotation(LivingEntity target) {
        Vec3 direction = this.calculateDirectionToTarget(target);
        double horizontalDistance = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float yaw = (float)Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0f;
        this.m_5616_(yaw);
        float pitch = (float)(-Math.toDegrees(Math.atan2(direction.f_82480_, horizontalDistance)));
        this.m_146926_(pitch);
    }

    static {
        IS_SHOOTING = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_BEING_PLACED = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_LEVELING_UP = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SENTRY_DAMAGE_BY_LEVEL = new float[]{0.0f, 5.0f, 10.0f, 15.0f, 20.0f, 25.0f};
        SUMMONING_TICK = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SUMMONER_UUID = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        SENTRY_LEVEL = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PLAYER_PROXIMITY_TIME = SynchedEntityData.m_135353_(SentryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

