/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShadowSubordinateEntity
extends TensuraTamableEntity
implements IFollower {
    private static final EntityDataAccessor<Float> HEIGHT;
    private static final EntityDataAccessor<Float> WIDTH;
    private int regenCooldown = 0;
    private static final EntityDataAccessor<CompoundTag> DATA_ORIGINAL_MOB_DATA;
    private CompoundTag cachedOriginalMobData = new CompoundTag();

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (HEIGHT.equals(pKey) || WIDTH.equals(pKey)) {
            this.m_20090_();
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose).m_20388_(RaceHelper.getSkillSizeMultiplier((LivingEntity)this)).m_20390_(this.getWidth(), this.getHeight());
        return !this.m_21827_() && !this.m_21825_() ? entitydimensions : entitydimensions.m_20390_(1.0f, 0.75f);
    }

    public ShadowSubordinateEntity(EntityType<? extends ShadowSubordinateEntity> type, Level level) {
        super(type, level);
    }

    public ShadowSubordinateEntity(Level level, BlockPos position, LivingEntity entity) {
        this((EntityType<? extends ShadowSubordinateEntity>)((EntityType)MysticismEntityTypes.SHADOW_SUBORDINATE.get()), level);
        this.m_6034_(position.m_123341_(), position.m_123342_(), position.m_123343_());
        this.setOriginalMobData(entity);
    }

    public float getHeight() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT)).floatValue();
    }

    public void setHeight(float pSize) {
        this.f_19804_.m_135381_(HEIGHT, (Object)Float.valueOf(pSize));
    }

    public float getWidth() {
        return ((Float)this.f_19804_.m_135370_(WIDTH)).floatValue();
    }

    public void setWidth(float pSize) {
        this.f_19804_.m_135381_(WIDTH, (Object)Float.valueOf(pSize));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ORIGINAL_MOB_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(HEIGHT, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(WIDTH, (Object)Float.valueOf(1.0f));
    }

    public void setOriginalMobData(@Nullable LivingEntity entity) {
        if (entity == null || this.hasOriginalMobData()) {
            return;
        }
        CompoundTag mobData = new CompoundTag();
        entity.m_20240_(mobData);
        if (!mobData.m_128441_("id")) {
            mobData.m_128359_("id", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
        }
        this.f_19804_.m_135381_(DATA_ORIGINAL_MOB_DATA, (Object)mobData);
        this.cachedOriginalMobData = mobData;
    }

    public CompoundTag getOriginalMobData() {
        if (this.cachedOriginalMobData.m_128456_()) {
            this.cachedOriginalMobData = (CompoundTag)this.f_19804_.m_135370_(DATA_ORIGINAL_MOB_DATA);
        }
        return this.cachedOriginalMobData;
    }

    public boolean hasOriginalMobData() {
        return !this.getOriginalMobData().m_128456_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("OriginalMobData", (Tag)this.getOriginalMobData());
        compound.m_128350_("Height", this.getHeight());
        compound.m_128350_("Width", this.getWidth());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("OriginalMobData")) {
            this.f_19804_.m_135381_(DATA_ORIGINAL_MOB_DATA, (Object)compound.m_128469_("OriginalMobData"));
            this.cachedOriginalMobData = compound.m_128469_("OriginalMobData");
        }
        this.setHeight(compound.m_128457_("Height"));
        this.setWidth(compound.m_128457_("Width"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.f_19853_.m_46462_() && this.m_21223_() < this.m_21233_()) {
            ++this.regenCooldown;
            if (this.regenCooldown >= 20) {
                this.m_5634_(1.0f);
                this.regenCooldown = 0;
            }
        }
        if (this.f_19853_.f_46443_ && this.hasOriginalMobData()) {
            double minX = this.m_20191_().f_82288_;
            double minY = this.m_20191_().f_82289_;
            double minZ = this.m_20191_().f_82290_;
            double maxX = this.m_20191_().f_82291_;
            double maxY = this.m_20191_().f_82292_;
            double maxZ = this.m_20191_().f_82293_;
            for (int i = 0; i < 5; ++i) {
                double x = minX + this.f_19796_.m_188500_() * (maxX - minX);
                double y = minY + this.f_19796_.m_188500_() * (maxY - minY);
                double z = minZ + this.f_19796_.m_188500_() * (maxZ - minZ);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.02, 0.0);
            }
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22284_, 100.0).m_22268_(Attributes.f_22276_, 10000.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(3, (Goal)new WanderingFollowOwnerGoal((TensuraTamableEntity)this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new TensuraTamableEntity.WanderAroundPosGoal((TensuraTamableEntity)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal((TensuraTamableEntity)this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal((TensuraTamableEntity)this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, null));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (this.isPhysicalAttack(pSource)) {
            pAmount *= 0.05f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean shouldFollow() {
        return false;
    }

    private boolean isPhysicalAttack(DamageSource damageSource) {
        if (DamageSourceHelper.isPhysicalAttack((DamageSource)damageSource)) {
            Entity entity = damageSource.m_7640_();
            if (entity == null) {
                return false;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                return !RaceHelper.isSpiritual((LivingEntity)living);
            }
            return false;
        }
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public int getRegenCooldown() {
        return this.regenCooldown;
    }

    public CompoundTag getCachedOriginalMobData() {
        return this.cachedOriginalMobData;
    }

    static {
        DATA_ORIGINAL_MOB_DATA = SynchedEntityData.m_135353_(ShadowSubordinateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        HEIGHT = SynchedEntityData.m_135353_(ShadowSubordinateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        WIDTH = SynchedEntityData.m_135353_(ShadowSubordinateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

