/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.entity.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TerritoryEntity
extends TensuraTamableEntity
implements IAnimatable {
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID;
    private static final EntityDataAccessor<Integer> SUMMONING_TICK;
    private UUID ownerUUID;
    private final long creationTime;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int regenTickCounter = 0;

    public TerritoryEntity(EntityType<? extends TensuraTamableEntity> entityType, Level level) {
        super(entityType, level);
        this.creationTime = System.currentTimeMillis();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 22.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        LivingEntity owner = this.m_21826_();
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22276_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22281_);
        this.copyAttributeFromOwner(owner, () -> Attributes.f_22284_);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_MAGICULE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_AURA);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.BARRIER);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.SIZE);
        this.copyAttributeFromOwner(owner, (Supplier<Attribute>)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH);
        this.m_21153_((float)this.m_21204_().m_22181_(Attributes.f_22276_));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void copyAttributeFromOwner(LivingEntity owner, Supplier<Attribute> attributeSupplier) {
        Attribute attribute = attributeSupplier.get();
        if (owner == null) {
            return;
        }
        boolean ownerHas = owner.m_21204_().m_22171_(attribute);
        boolean selfHas = this.m_21204_().m_22171_(attribute);
        if (ownerHas && selfHas) {
            double ownerValue = owner.m_21051_(attribute).m_22135_();
            this.m_21051_(attribute).m_22100_(ownerValue);
        }
    }

    public void setOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("SummoningTick", this.getSummoningTick());
    }

    public boolean m_6094_() {
        return false;
    }

    private boolean isAllied(LivingEntity entity) {
        Player owner = (Player)this.m_21826_();
        return owner != null && (entity == owner || entity.m_7307_((Entity)owner));
    }

    private void healNearbyAllies() {
        AABB area = new AABB(this.m_20183_()).m_82400_(128.0);
        List entities = this.f_19853_.m_45976_(LivingEntity.class, area);
        float baseRegeneration = 0.03f;
        for (LivingEntity entity : entities) {
            if (entity == this) continue;
            if (this.isAllied(entity)) {
                double maxHP = entity.m_21233_();
                entity.m_5634_((float)(maxHP * 0.05) + 10.0f);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_36324_().m_38717_(Math.min(player.m_36324_().m_38722_() + 1.0f, 20.0f));
                    TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                        double regenAmount;
                        double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                        double maxAP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                        if (cap.getMagicule() < maxMP) {
                            regenAmount = maxMP * (double)baseRegeneration;
                            double newMana = cap.getMagicule() + regenAmount;
                            cap.setMagicule(Math.min(newMana, maxMP));
                        }
                        if (cap.getAura() < maxAP) {
                            regenAmount = maxAP * (double)baseRegeneration;
                            double newAura = cap.getAura() + regenAmount;
                            cap.setAura(Math.min(newAura, maxAP));
                        }
                        TensuraPlayerCapability.sync((Player)player);
                    });
                    continue;
                }
                TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                    double maxEP = cap.getEP();
                    double currentEP = cap.getCurrentEP();
                    if (currentEP < maxEP) {
                        double regenAmount = maxEP * (double)baseRegeneration;
                        cap.setCurrentEP(entity, Math.min(currentEP + regenAmount, maxEP));
                        TensuraEPCapability.sync((LivingEntity)entity);
                    }
                });
                continue;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                    double maxMP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                    double maxAP = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                    double regenAmount = maxMP * (double)-0.01f;
                    double newMana = cap.getMagicule() + regenAmount;
                    cap.setMagicule(Math.min(newMana, maxMP));
                    double newAura = cap.getAura() + regenAmount;
                    cap.setAura(Math.min(newAura, maxAP));
                    TensuraPlayerCapability.sync((Player)player);
                });
                continue;
            }
            TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                double maxEP = cap.getEP();
                double currentEP = cap.getCurrentEP();
                double regenAmount = maxEP * (double)-0.06f;
                cap.setCurrentEP(entity, Math.min(currentEP + regenAmount, maxEP));
                TensuraEPCapability.sync((LivingEntity)entity);
            });
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        return false;
    }

    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    public void setSummonerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(uuid));
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_21826_() != null && !SkillUtils.hasSkill((Entity)this.m_21826_(), (ManasSkill)((ManasSkill)UltimateSkills.GILGAMESH.get()))) {
                this.m_146870_();
            }
            ++this.regenTickCounter;
            if (this.regenTickCounter >= 60) {
                this.healNearbyAllies();
                this.regenTickCounter = 0;
            }
        }
    }

    static {
        SUMMONING_TICK = SynchedEntityData.m_135353_(TerritoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SUMMONER_UUID = SynchedEntityData.m_135353_(TerritoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    }
}

