/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.event.PossessionEvent;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.entity.OkamiEntity;
import io.github.Memoires.trmysticism.race.angel.ArchAngelRace;
import io.github.Memoires.trmysticism.race.angel.CherubRace;
import io.github.Memoires.trmysticism.race.angel.GreaterAngelRace;
import io.github.Memoires.trmysticism.race.angel.LesserAngelRace;
import io.github.Memoires.trmysticism.race.angel.SeraphimRace;
import io.github.Memoires.trmysticism.registry.items.MysticismMobDropItems;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AngelEvolutionHandler {
    private static final Set<UUID> evolvedThisTick = new HashSet<UUID>();
    private static final Set<UUID> messageSentThisTick = new HashSet<UUID>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.f_19797_ % 5 != 0) {
                return;
            }
            Player player = event.player;
            UUID playerId = player.m_20148_();
            if (TensuraEPCapability.isMajin((LivingEntity)player) && !evolvedThisTick.contains(playerId)) {
                AngelEvolutionHandler.evolvePlayerIfNeededinFallenAngel(player);
                evolvedThisTick.add(playerId);
            }
            evolvedThisTick.clear();
            messageSentThisTick.clear();
        }
    }

    private static void evolvePlayerIfNeededinFallenAngel(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (raceRegistry != null && playerRace != null) {
            if (playerRace.getClass() == LesserAngelRace.class) {
                AngelEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_LESSER_ANGEL);
            } else if (playerRace.getClass() == GreaterAngelRace.class) {
                AngelEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_GREATER_ANGEL);
            } else if (playerRace.getClass() == ArchAngelRace.class) {
                AngelEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_ARCHANGEL);
            } else if (playerRace.getClass() == CherubRace.class) {
                AngelEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_CHERUB);
            } else if (playerRace.getClass() == SeraphimRace.class) {
                AngelEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_SERAPHIM);
            }
        }
    }

    private static void evolvePlayer(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You feel your wings darkening... You fell from grace!").m_130940_(ChatFormatting.LIGHT_PURPLE));
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f);
            messageSentThisTick.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onItemConsumed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack consumedItem = event.getItem();
        if (consumedItem.m_41720_() == MysticismMobDropItems.CRYPTID_ESSENCE.get()) {
            if (player.m_9236_().f_46443_) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int essenceConsumed = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)MysticismMobDropItems.CRYPTID_ESSENCE.get())));
            if (AngelEvolutionHandler.shouldBecomePhantom(player, essenceConsumed)) {
                AngelEvolutionHandler.evolvePlayerIntoPhantom(player);
            }
        }
    }

    private static boolean shouldBecomePhantom(Player player, double essenceConsumed) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (playerRace != null) {
            if (playerRace.getClass() == LesserAngelRace.class) {
                return essenceConsumed >= 1.0;
            }
            if (playerRace.getClass() == GreaterAngelRace.class) {
                return essenceConsumed >= 3.0;
            }
            if (playerRace.getClass() == ArchAngelRace.class) {
                return essenceConsumed >= 5.0;
            }
            if (playerRace.getClass() == CherubRace.class) {
                return essenceConsumed >= 7.0;
            }
            if (playerRace.getClass() == SeraphimRace.class) {
                return essenceConsumed >= 10.0;
            }
        }
        return false;
    }

    private static void evolvePlayerIntoPhantom(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (raceRegistry != null && playerRace != null) {
            if (playerRace.getClass() == LesserAngelRace.class) {
                AngelEvolutionHandler.evolvePlayerPhantom(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.PHANTOM);
            } else if (playerRace.getClass() == GreaterAngelRace.class) {
                AngelEvolutionHandler.evolvePlayerPhantom(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FIELD_OFFICER);
            } else if (playerRace.getClass() == ArchAngelRace.class) {
                AngelEvolutionHandler.evolvePlayerPhantom(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.GENERAL);
            } else if (playerRace.getClass() == CherubRace.class) {
                AngelEvolutionHandler.evolvePlayerPhantom(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.STAFF_OFFICER);
            } else if (playerRace.getClass() == SeraphimRace.class) {
                AngelEvolutionHandler.evolvePlayerPhantom(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.MYSTIC_ANGEL);
            }
        }
    }

    private static void evolvePlayerPhantom(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You feel yourself being corrupted... You fell from grace!").m_130940_(ChatFormatting.DARK_BLUE));
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.0f);
            messageSentThisTick.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onPossession(PossessionEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (AngelEvolutionHandler.isSpecificEntity((Entity)target)) {
                AngelEvolutionHandler.applyEvolution(player);
            }
        }
    }

    private static boolean isSpecificEntity(Entity entity) {
        return entity.getClass() == OkamiEntity.class;
    }

    private static void evolvePlayerOnPossession(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You feel yourself being incarnated... You became a Tengu!").m_130940_(ChatFormatting.GOLD));
            messageSentThisTick.add(playerId);
        }
    }

    private static void applyEvolution(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (raceRegistry != null && playerRace != null) {
            if (playerRace.getClass() == GreaterAngelRace.class) {
                AngelEvolutionHandler.evolvePlayerOnPossession(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.TENGU);
            } else if (playerRace.getClass() == ArchAngelRace.class) {
                AngelEvolutionHandler.evolvePlayerOnPossession(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.TENGU);
            }
        }
    }
}

