/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import io.github.Memoires.trmysticism.race.angel.ArchAngelRace;
import io.github.Memoires.trmysticism.race.angel.CherubRace;
import io.github.Memoires.trmysticism.race.angel.GreaterAngelRace;
import io.github.Memoires.trmysticism.race.angel.LesserAngelRace;
import io.github.Memoires.trmysticism.race.angel.SeraphimRace;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AngelMajinHandler {
    @SubscribeEvent
    public static void onItemConsumed(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack consumedItem = event.getItem();
        if (consumedItem.m_41720_() == TensuraMobDropItems.DEMON_ESSENCE.get()) {
            if (player.m_9236_().f_46443_) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int essenceConsumed = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMobDropItems.DEMON_ESSENCE.get())));
            if (AngelMajinHandler.shouldBecomeMajin(player, essenceConsumed)) {
                AngelMajinHandler.makePlayerMajin(player);
            }
        }
    }

    private static boolean shouldBecomeMajin(Player player, double essenceConsumed) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (playerRace != null) {
            if (playerRace.getClass() == LesserAngelRace.class) {
                return essenceConsumed >= 1.0;
            }
            if (playerRace.getClass() == GreaterAngelRace.class) {
                return essenceConsumed >= 3.0;
            }
            if (playerRace.getClass() == ArchAngelRace.class) {
                return essenceConsumed >= 5.0;
            }
            if (playerRace.getClass() == CherubRace.class) {
                return essenceConsumed >= 7.0;
            }
            if (playerRace.getClass() == SeraphimRace.class) {
                return essenceConsumed >= 10.0;
            }
        }
        return false;
    }

    private static void makePlayerMajin(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> TensuraEPCapability.setMajin((LivingEntity)player, (boolean)true));
    }
}

