/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import io.github.Memoires.trmysticism.api.ICapabilityHasOwner;
import io.github.Memoires.trmysticism.capability.race.IMysticismPlayerCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityHandler {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(IMysticismPlayerCapability.class);
    }

    @SubscribeEvent
    static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        MysticismPlayerCapability.checkForFirstLogin(player);
        MysticismPlayerCapability.sync(player);
    }

    @SubscribeEvent
    static void onPlayerTrack(PlayerEvent.StartTracking e) {
        Entity entity = e.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MysticismPlayerCapability.sync(player);
            MysticismPlayerCapability.sync(e.getEntity());
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone e) {
        e.getOriginal().reviveCaps();
        Player newPlayer = e.getEntity();
        MysticismPlayerCapability.getFrom(e.getOriginal()).ifPresent(oldData -> MysticismPlayerCapability.getFrom(newPlayer).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        if (!e.isWasDeath()) {
            newPlayer.m_6210_();
        }
        e.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        MysticismPlayerCapability.checkForFirstLogin(player);
        MysticismPlayerCapability.sync(player);
    }

    @SubscribeEvent
    static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        MysticismPlayerCapability.sync(e.getEntity());
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> ((ICapabilityHasOwner)cap).setOwner((LivingEntity)player));
        }
    }

    @Nullable
    public static <T> T getCapability(Entity entity, Capability<T> capability) {
        return (T)(entity.getCapability(capability).isPresent() ? entity.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }
}

