/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.ITensuraSkillCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.api.Contract;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.network.MysticismNetwork;
import io.github.Memoires.trmysticism.network.play2client.CloseContractGUIPacket;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import io.github.Memoires.trmysticism.util.ContractMagicTable;
import io.github.Memoires.trmysticism.world.ContractLedger;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="trmysticism")
public class ContractHandler {
    private static boolean cancelDamage;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)event.player);
        if (!(playerRace != null && (playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.LESSER_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.MEDIUM_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.GREATER_SPIRIT)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.SPIRIT_LORD)) || playerRace.equals(((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.ELEMENTAL_QUEEN))))) {
            return;
        }
        if (event.side.isClient()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MysticismPlayerCapability.getFrom(event.player).ifPresent(cap -> {
            ArrayList<Contract> pendingContracts = new ArrayList<Contract>(cap.getPendingContracts());
            for (Contract contract : pendingContracts) {
                if (event.player.f_19853_.m_46467_() < contract.getArrivalTime() + 2400L) continue;
                cap.cancelPendingContract(contract);
                event.player.m_5661_((Component)Component.m_237113_((String)"Contract request has expired!").m_130940_(ChatFormatting.RED), false);
                MysticismNetwork.sendTo(new CloseContractGUIPacket(contract), (LivingEntity)event.player);
            }
            if (cap.getActiveContract() != null) {
                ServerPlayer contractor = (ServerPlayer)event.player;
                UUID contracteeId = cap.getActiveContract().getContracteeUUID();
                Player contractee = contractor.f_19853_.m_46003_(contracteeId);
                if (cap instanceof MysticismPlayerCapability) {
                    MysticismPlayerCapability impl = (MysticismPlayerCapability)cap;
                    UUID want = impl.getPendingCameraTarget();
                    int retries = impl.getCameraRetryTicks();
                    if (want != null && retries > 0) {
                        Player tgt = contractor.f_19853_.m_46003_(want);
                        if (tgt != null && contractor.m_8954_() != tgt) {
                            contractor.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)tgt));
                        }
                        impl.setCameraRetryTicks(retries - 1);
                        if (tgt != null && contractor.m_8954_() == tgt || impl.getCameraRetryTicks() <= 0) {
                            impl.setPendingCameraTarget(null);
                        }
                    }
                }
                if (contractee == null) {
                    contractor.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)contractor));
                    cap.restoreGamemodeIfSpectator(contractor);
                    return;
                }
                if (!cap.getSummonStatus() && TensuraPlayerCapability.isSpiritualForm((Player)contractor)) {
                    if (contractor.f_8941_.m_9290_() != GameType.SPECTATOR) {
                        if (cap.getSavedGamemode() == null) {
                            cap.setSavedGamemode(contractor.f_8941_.m_9290_());
                        }
                        contractor.m_143403_(GameType.SPECTATOR);
                    }
                    contractor.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)contractee));
                } else if (cap.getSummonStatus()) {
                    cap.restoreGamemodeIfSpectator(contractor);
                    if (contractor.f_19853_.m_46472_() != contractee.f_19853_.m_46472_()) {
                        SkillHelper.moveAcrossDimensionTo((Entity)contractor, (Entity)contractee);
                    }
                    contractor.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)contractor));
                }
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer gone = (ServerPlayer)player;
        MinecraftServer server = gone.m_20194_();
        if (server == null) {
            return;
        }
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            MysticismPlayerCapability.getFrom((Player)sp).ifPresent(cap -> {
                Contract active = cap.getActiveContract();
                if (active != null && active.getContracteeUUID().equals(gone.m_20148_())) {
                    cap.setSummonStatus(true);
                    sp.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)sp));
                    cap.restoreGamemodeIfSpectator(sp);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ServerLevel srv = sp.m_9236_();
        ContractLedger ledger = ContractLedger.get(srv);
        MysticismPlayerCapability.getFrom((Player)sp).ifPresent(cap -> {
            Contract active = cap.getActiveContract();
            if (active != null) {
                for (ContractLedger.Entry e : ledger.allFor(sp.m_20148_())) {
                    if (e.id != active.getId() || e.status != ContractLedger.Status.DISSOLVED) continue;
                    Player contractor = sp.m_9236_().m_46003_(active.getContractorUUID());
                    if (contractor != null) {
                        sp.m_5661_((Component)Component.m_237110_((String)"trmysticism.command.force_dissolve.offline_dissolve_name", (Object[])new Object[]{contractor.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    } else {
                        sp.m_5661_((Component)Component.m_237115_((String)"trmysticism.command.force_dissolve.offline_dissolve").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                    cap.dissolveContract(active);
                    ContractHandler.revokeGivenSkillsIfNeeded(sp, active);
                    MagicElemental element = active.getElement();
                    LazyOptional skillCapLO = TensuraSkillCapability.getFrom((Player)sp);
                    ITensuraSkillCapability skillCap = (ITensuraSkillCapability)skillCapLO.orElse(null);
                    if (skillCap == null || element == null) break;
                    skillCap.setSpiritLevel((Player)sp, element.getId(), 0);
                    break;
                }
            }
            cap.getAcceptedContracts().entrySet().removeIf(en -> {
                MagicElemental elem = (MagicElemental)en.getKey();
                Contract c = (Contract)en.getValue();
                for (ContractLedger.Entry e : ledger.allFor(sp.m_20148_())) {
                    if (e.id != c.getId() || e.status != ContractLedger.Status.DISSOLVED) continue;
                    ContractHandler.revokeGivenSkillsIfNeeded(sp, c);
                    return true;
                }
                return false;
            });
            MysticismPlayerCapability.sync((Player)sp);
        });
    }

    @SubscribeEvent
    public static void onContractorJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        MysticismPlayerCapability.getFrom((Player)sp).ifPresent(cap -> {
            Player contractor;
            Contract active = cap.getActiveContract();
            if (active != null && (contractor = sp.m_9236_().m_46003_(active.getContractorUUID())) != null && contractor.m_20148_() == sp.m_20148_() && contractor.m_9236_().m_46003_(active.getContracteeUUID()) != null) {
                cap.restoreGamemodeIfSpectator(sp);
            }
        });
    }

    @SubscribeEvent
    public static void onContracteeDeath(LivingDeathEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer contractee = (ServerPlayer)livingEntity;
        DamageSource deathSource = event.getSource();
        MysticismPlayerCapability.getFrom((Player)contractee).ifPresent(contracteeCap -> {
            ArrayList<Contract> accepted = new ArrayList<Contract>(contracteeCap.getAcceptedContracts().values());
            if (accepted.isEmpty()) {
                return;
            }
            for (Contract c : accepted) {
                UUID contractorId = c.getContractorUUID();
                ServerPlayer contractor = contractee.m_20194_().m_6846_().m_11259_(contractorId);
                if (contractor == null) continue;
                MysticismPlayerCapability.getFrom((Player)contractor).ifPresent(conCap -> {
                    conCap.setSummonStatus(false);
                    contractor.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)contractor));
                    conCap.restoreGamemodeIfSpectator(contractor);
                });
                if (!contractor.m_6469_(deathSource, Float.MAX_VALUE)) continue;
                contractor.m_6074_();
            }
        });
    }

    public static void revokeGivenSkillsIfNeeded(ServerPlayer loggingIn, Contract contract) {
        if (!loggingIn.m_20148_().equals(contract.getContracteeUUID())) {
            return;
        }
        MagicElemental element = contract.getElement();
        if (element == null) {
            return;
        }
        int tier = contract.getGrantedTier();
        if (tier > 0) {
            ContractMagicTable.revoke(loggingIn, element, tier);
        } else {
            ContractMagicTable.revokeMax(loggingIn, element);
        }
    }
}

