/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.event.PossessionEvent;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.race.daemon.ArchDaemonRace;
import com.github.manasmods.tensura.race.daemon.GreaterDaemonRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.entity.golems.AdamantiteGolemEntity;
import io.github.Memoires.trmysticism.entity.golems.HighMagisteelGolemEntity;
import io.github.Memoires.trmysticism.entity.golems.LowMagisteelGolemEntity;
import io.github.Memoires.trmysticism.entity.golems.OrichalcumGolemEntity;
import io.github.Memoires.trmysticism.entity.golems.PureMagisteelGolemEntity;
import io.github.Memoires.trmysticism.race.daemonDoll.ArchDollRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DaemonEvolutionHandler {
    private static final Set<UUID> evolvedThisTick = new HashSet<UUID>();
    private static final Set<UUID> messageSentThisTick = new HashSet<UUID>();
    public static boolean isGolem = false;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.f_19797_ % 5 != 0) {
                return;
            }
            Player player = event.player;
            UUID playerId = player.m_20148_();
            if (TensuraEPCapability.isChaos((LivingEntity)player) && !evolvedThisTick.contains(playerId)) {
                DaemonEvolutionHandler.evolvePlayerIfNeeded(player);
                evolvedThisTick.add(playerId);
            }
            evolvedThisTick.clear();
            messageSentThisTick.clear();
        }
    }

    private static void evolvePlayerIfNeeded(Player player) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (playerRace != null && raceRegistry != null && playerRace.getClass() == ArchDollRace.class) {
            DaemonEvolutionHandler.evolvePlayer(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.CHAOS_DOLL);
        }
    }

    private static void evolvePlayer(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You feel a new power surging within you...").m_130940_(ChatFormatting.DARK_RED));
            messageSentThisTick.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onPossession(PossessionEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getAttacker();
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (target instanceof LowMagisteelGolemEntity) {
                DaemonEvolutionHandler.applyEvolution(player, target);
            }
        }
    }

    private static void evolvePlayerOnPossession(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You feel yourself being incarnated...").m_130940_(ChatFormatting.RED));
            messageSentThisTick.add(playerId);
        }
    }

    private static void applyEvolution(Player player, LivingEntity entity) {
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (raceRegistry != null && playerRace != null) {
            if (playerRace.getClass() == GreaterDaemonRace.class) {
                double playerMag = entity.getClass() == LowMagisteelGolemEntity.class ? 10000.0 : (entity.getClass() == HighMagisteelGolemEntity.class ? 18000.0 : (entity.getClass() == PureMagisteelGolemEntity.class ? 52000.0 : (entity.getClass() == OrichalcumGolemEntity.class ? 80000.0 : (entity.getClass() == AdamantiteGolemEntity.class ? 225000.0 : 0.0))));
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setBaseMagicule(cap.getBaseMagicule() + playerMag, (LivingEntity)player));
                TensuraPlayerCapability.sync((Player)player);
                DaemonEvolutionHandler.evolvePlayerOnPossession(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.GREATER_DOLL);
            } else if (playerRace.getClass() == ArchDaemonRace.class) {
                double playerMag = entity.getClass() == LowMagisteelGolemEntity.class ? 10000.0 : (entity.getClass() == HighMagisteelGolemEntity.class ? 18000.0 : (entity.getClass() == PureMagisteelGolemEntity.class ? 52000.0 : (entity.getClass() == OrichalcumGolemEntity.class ? 80000.0 : (entity.getClass() == AdamantiteGolemEntity.class ? 225000.0 : 0.0))));
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> cap.setBaseMagicule(cap.getBaseMagicule() + playerMag, (LivingEntity)player));
                TensuraPlayerCapability.sync((Player)player);
                DaemonEvolutionHandler.evolvePlayerOnPossession(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.ARCH_DOLL);
            }
        }
    }
}

