/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import java.util.ArrayList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="trmysticism")
public class DirewolfRideHandler {
    @SubscribeEvent
    public static void onDirewolfLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (sp.f_19853_.f_46443_) {
            return;
        }
        if (DirewolfRideHandler.bottomMostServerPlayer((Entity)sp) == sp) {
            DirewolfRideHandler.dismountAllPassengersRecursive((Entity)sp);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeGamemode(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        if (player.m_20160_()) {
            player.m_146895_().m_8127_();
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        if (!event.getSource().m_146707_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (DirewolfRideHandler.hasPlayerVehicle((Entity)sp)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity victim = event.getEntity();
        if (!(victim instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer target = (ServerPlayer)victim;
        Entity src = DirewolfRideHandler.resolveTrueAttacker(event.getSource());
        if (!(src instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)src;
        if (DirewolfRideHandler.shareSameDirewolfBase(attacker, target)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDirewolfDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer victim = (ServerPlayer)livingEntity;
        if (victim.f_19853_.f_46443_) {
            return;
        }
        ServerPlayer base = DirewolfRideHandler.bottomMostServerPlayer((Entity)victim);
        if (base == victim) {
            DirewolfRideHandler.dismountAllPassengersRecursive((Entity)victim);
        }
    }

    @Nullable
    private static ServerPlayer bottomMostServerPlayer(Entity e) {
        ServerPlayer sp;
        Entity cur = e;
        while (cur.m_20202_() != null) {
            cur = cur.m_20202_();
        }
        return cur instanceof ServerPlayer ? (sp = (ServerPlayer)cur) : null;
    }

    private static boolean shareSameDirewolfBase(ServerPlayer a, ServerPlayer b) {
        ServerPlayer baseA = DirewolfRideHandler.bottomMostServerPlayer((Entity)a);
        ServerPlayer baseB = DirewolfRideHandler.bottomMostServerPlayer((Entity)b);
        return baseA != null && baseA == baseB && a != b;
    }

    private static boolean hasPlayerVehicle(Entity e) {
        for (Entity v = e.m_20202_(); v != null; v = v.m_20202_()) {
            if (!(v instanceof ServerPlayer)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Entity resolveTrueAttacker(DamageSource src) {
        Projectile proj;
        Entity owner = null;
        Entity direct = src.m_7640_();
        if (direct instanceof Projectile && (owner = (proj = (Projectile)direct).m_37282_()) != null) {
            return owner;
        }
        return src.m_7639_();
    }

    private static void dismountAllPassengersRecursive(Entity e) {
        ArrayList copy = new ArrayList(e.m_20197_());
        for (Entity p : copy) {
            DirewolfRideHandler.dismountAllPassengersRecursive(p);
            p.m_8127_();
        }
    }
}

