/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.event.UpdateEPEvent;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import io.github.Memoires.trmysticism.capability.DragonoidStatsCapability;
import io.github.Memoires.trmysticism.config.MysticismConfig;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="trmysticism")
public class DragonoidRaceHandler {
    @SubscribeEvent
    public static void onEPGain(UpdateEPEvent e) {
        if (TensuraPlayerCapability.getRace((LivingEntity)e.getEntity()) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRAGONOID)) {
            double EP = e.getNewEP();
            double maxEP = (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidMaxEP.get();
            EP = Math.max(EP, (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidMinEP.get());
            EP = Math.min(EP, maxEP);
            int incrementSteps = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidHpIncrease.get());
            double newHealth = 30.0 + (double)incrementSteps * 5.0;
            int attackDamageIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidDmgIncrease.get());
            double newAttackDamage = 1.0 + (double)attackDamageIncrements * 0.15;
            int attackSpeedIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidAtkSpeedIncrease.get());
            double newAttackSpeed = 4.0 + (double)attackSpeedIncrements * 0.1;
            int sprintSpeedIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidSprintSpeedIncrease.get());
            double newSprintSpeed = 1.5 + (double)sprintSpeedIncrements * 0.05;
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22276_)).m_22100_(newHealth);
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22281_)).m_22100_(newAttackDamage);
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22283_)).m_22100_(newAttackSpeed);
            Objects.requireNonNull(e.getEntity().m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())).m_22100_(newSprintSpeed);
            Objects.requireNonNull(e.getEntity().m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())).m_22100_(newHealth * 6.0);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.PlayerRespawnEvent e) {
        if (TensuraPlayerCapability.getRace((LivingEntity)e.getEntity()) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRAGONOID)) {
            double EP = TensuraPlayerCapability.getCurrentEP((Player)e.getEntity());
            double maxEP = (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidMaxEP.get();
            EP = Math.max(EP, (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidMinEP.get());
            EP = Math.min(EP, maxEP);
            int incrementSteps = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidHpIncrease.get());
            double newHealth = 30.0 + (double)incrementSteps * 5.0;
            int attackDamageIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidDmgIncrease.get());
            double newAttackDamage = 1.0 + (double)attackDamageIncrements * 0.05;
            int attackSpeedIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidAtkSpeedIncrease.get());
            double newAttackSpeed = 4.0 + (double)attackSpeedIncrements * 0.1;
            int sprintSpeedIncrements = (int)(EP / (Double)MysticismConfig.INSTANCE.racesConfig.dragonoidSprintSpeedIncrease.get());
            double newSprintSpeed = 1.5 + (double)sprintSpeedIncrements * 0.05;
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22276_)).m_22100_(newHealth);
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22281_)).m_22100_(newAttackDamage);
            Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22283_)).m_22100_(newAttackSpeed);
            Objects.requireNonNull(e.getEntity().m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())).m_22100_(newSprintSpeed);
            Objects.requireNonNull(e.getEntity().m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())).m_22100_(newHealth * 6.0);
            TensuraEPCapability.setSpiritualHealth((LivingEntity)e.getEntity(), (double)e.getEntity().m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
            e.getEntity().m_21153_((float)newHealth);
        }
    }

    @SubscribeEvent
    public static void onUseReset(PlayerInteractEvent.RightClickItem e) {
        if (TensuraPlayerCapability.getRace((LivingEntity)e.getEntity()) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRAGONOID)) {
            ItemStack itemStack = e.getItemStack();
            if (itemStack.m_41720_() == TensuraMaterialItems.CHARACTER_RESET_SCROLL.get()) {
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22276_)).m_22100_(30.0);
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22281_)).m_22100_(1.0);
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22283_)).m_22100_(4.0);
                Objects.requireNonNull(e.getEntity().m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())).m_22100_(1.5);
                Objects.requireNonNull(e.getEntity().m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())).m_22100_(120.0);
                e.getEntity().m_21153_(30.0f);
            } else if (itemStack.m_41720_() == TensuraMaterialItems.RACE_RESET_SCROLL.get()) {
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22276_)).m_22100_(30.0);
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22281_)).m_22100_(1.0);
                Objects.requireNonNull(e.getEntity().m_21051_(Attributes.f_22283_)).m_22100_(4.0);
                Objects.requireNonNull(e.getEntity().m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())).m_22100_(1.5);
                Objects.requireNonNull(e.getEntity().m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())).m_22100_(120.0);
                e.getEntity().m_21153_(30.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (TensuraPlayerCapability.getRace((LivingEntity)event.getEntity()) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRAGONOID)) {
            Player player = event.getEntity();
            player.getCapability(DragonoidStatsCapability.DRAGONOID_STATS).ifPresent(stats -> {
                stats.setHealth(player.m_21223_());
                stats.setAttackDamage(player.m_21133_(Attributes.f_22281_));
                stats.setAttackSpeed(player.m_21133_(Attributes.f_22283_));
                stats.setSprintSpeed(player.m_21133_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()));
                stats.setSpiritualHealth(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (TensuraPlayerCapability.getRace((LivingEntity)event.getEntity()) == ((IForgeRegistry)TensuraRaces.RACE_REGISTRY.get()).getValue(MysticismRaces.DRAGONOID)) {
            Player player = event.getEntity();
            player.getCapability(DragonoidStatsCapability.DRAGONOID_STATS).ifPresent(stats -> {
                Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22100_(stats.getHealth());
                Objects.requireNonNull(player.m_21051_(Attributes.f_22281_)).m_22100_(stats.getAttackDamage());
                Objects.requireNonNull(player.m_21051_(Attributes.f_22283_)).m_22100_(stats.getAttackSpeed());
                Objects.requireNonNull(player.m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())).m_22100_(stats.getSprintSpeed());
                Objects.requireNonNull(player.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())).m_22100_(stats.getSpiritualHealth());
                player.m_21153_((float)stats.getHealth());
            });
        }
    }
}

