/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.race.elemental.MediumSpiritRace;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElementalCoreHandler {
    @SubscribeEvent
    public static void onSpiritRightClick(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        Entity entity = event.getTarget();
        if (!(entity instanceof Player)) {
            return;
        }
        Player targetSpirit = (Player)entity;
        Race targetRace = TensuraPlayerCapability.getRace((LivingEntity)targetSpirit);
        if (!(targetRace instanceof MediumSpiritRace)) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_EMPTY.get())) {
            return;
        }
        MagicElemental element = MysticismPlayerCapability.getElement(targetSpirit);
        if (element == null || element == MagicElemental.DARKNESS || element == MagicElemental.LIGHT) {
            return;
        }
        Item newCore = ElementalCoreHandler.getCoreForElement(element);
        if (newCore == null) {
            return;
        }
        double EP = TensuraEPCapability.getEP((LivingEntity)targetSpirit);
        int cost = (Integer)TensuraConfig.INSTANCE.itemsConfig.elementalCoreCost.get();
        DamageSourceHelper.markHurt((LivingEntity)targetSpirit, (Entity)null);
        if (EP < (double)cost) {
            targetSpirit.m_9236_().m_6269_((Player)null, (Entity)targetSpirit, SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
            event.setCanceled(true);
        } else {
            TensuraEPCapability.getFrom((LivingEntity)targetSpirit).ifPresent(cap -> {
                cap.setEP((LivingEntity)targetSpirit, EP - (double)cost);
                TensuraEPCapability.sync((LivingEntity)targetSpirit);
            });
            player.m_21008_(hand, new ItemStack((ItemLike)newCore));
            level.m_5594_(null, targetSpirit.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    private static Item getCoreForElement(MagicElemental element) {
        return switch (element) {
            default -> throw new IncompatibleClassChangeError();
            case MagicElemental.WIND -> (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get();
            case MagicElemental.EARTH -> (Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get();
            case MagicElemental.FLAME -> (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get();
            case MagicElemental.WATER -> (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get();
            case MagicElemental.SPACE -> (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get();
            case MagicElemental.DARKNESS -> (Item)TensuraMaterialItems.ELEMENT_CORE_EMPTY.get();
            case MagicElemental.LIGHT -> (Item)TensuraMaterialItems.ELEMENT_CORE_EMPTY.get();
        };
    }
}

