/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import io.github.Memoires.trmysticism.registry.biome.MysticismBiomes;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElementalRealmHandler {
    private static final Random random = new Random();
    private static final float MIDDLE_SPIRIT_CHANCE = 15.0f;
    private static final float VANILLA_MOB_CHANCE = 50.0f;
    private static final float GREATER_SPIRIT_CHANCE = 1.0f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!event.player.m_9236_().m_46472_().equals(MysticismDimensions.ELEMENTAL_REALM)) {
                return;
            }
            if (event.player.f_19797_ % 40 != 0) {
                return;
            }
            ElementalRealmHandler.FireBiomeSpawn(event.player);
            ElementalRealmHandler.WaterBiomeSpawn(event.player);
            ElementalRealmHandler.WindBiomeSpawn(event.player);
            ElementalRealmHandler.EarthBiomeSpawn(event.player);
            ElementalRealmHandler.SpaceBiomeSpawn(event.player);
            ElementalRealmHandler.DarknessBiomeSpawn(event.player);
            ElementalRealmHandler.LightBiomeSpawn(event.player);
        }
    }

    public static void FireBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.FIRE_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.SALAMANDER.get()), 1, 3);
            }
            if (random.nextFloat() < 0.5f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)EntityType.f_20551_, 1, 3);
            }
            if (random.nextFloat() < 0.01f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.IFRIT.get()), 1, 1);
            }
        }
    }

    private static void spawnMob(Player player, EntityType<? extends Mob> mobType, int minGroupSize, int maxGroupSize) {
        Level level = player.f_19853_;
        int entityLimit = 30;
        int nearbyEntities = level.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(48.0), e -> !(e instanceof Player)).size();
        if (nearbyEntities >= entityLimit) {
            return;
        }
        int count = minGroupSize + random.nextInt(maxGroupSize - minGroupSize + 1);
        for (int i = 0; i < count; ++i) {
            Mob mob;
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = 45.0 + random.nextDouble() * 10.0;
            int x = player.m_20183_().m_123341_() + (int)(Math.cos(angle) * distance);
            int z = player.m_20183_().m_123343_() + (int)(Math.sin(angle) * distance);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            BlockPos spawnPos = new BlockPos(x, y, z);
            BlockState blockBelow = level.m_8055_(spawnPos.m_7495_());
            BlockState blockAbove = level.m_8055_(spawnPos.m_7494_());
            if (!blockBelow.m_60767_().m_76333_() || !blockAbove.m_60767_().m_76336_() || (mob = (Mob)mobType.m_20615_(level)) == null) continue;
            mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.m_7967_((Entity)mob);
        }
    }

    public static void WaterBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.WATER_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.AQUA_FROG.get()), 1, 3);
            }
            if (random.nextFloat() < 0.5f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.LANDFISH.get()), 1, 3);
            }
            if (random.nextFloat() < 0.01f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.UNDINE.get()), 1, 1);
            }
        }
    }

    public static void EarthBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.EARTH_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.BEAST_GNOME.get()), 1, 3);
            }
            if (random.nextFloat() < 0.01f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.WAR_GNOME.get()), 1, 1);
            }
        }
    }

    public static void WindBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.WIND_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.FEATHERED_SERPENT.get()), 1, 3);
            }
            if (random.nextFloat() < 0.5f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.DRAGON_PEACOCK.get()), 1, 3);
            }
            if (random.nextFloat() < 0.01f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.SYLPHIDE.get()), 1, 1);
            }
        }
    }

    public static void SpaceBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.SPATIAL_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.WINGED_CAT.get()), 1, 3);
            }
            if (random.nextFloat() < 0.5f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)EntityType.f_20521_, 1, 3);
            }
            if (random.nextFloat() < 0.01f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)TensuraEntityTypes.AKASH.get()), 1, 1);
            }
        }
    }

    public static void DarknessBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.DARKNESS_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.5f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)EntityType.f_20497_, 1, 3);
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)MysticismEntityTypes.SHADOW_IMP.get()), 1, 2);
            }
        }
    }

    public static void LightBiomeSpawn(Player player) {
        if (!player.f_19853_.f_46443_ && player.f_19853_.m_204166_(player.m_20183_()).m_203373_(MysticismBiomes.LIGHT_BIOME.getId())) {
            int nearbyPlayers = 1;
            if (!player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).isEmpty()) {
                nearbyPlayers = player.f_19853_.m_45976_(Player.class, player.m_20191_().m_82400_(48.0)).size() + 1;
            }
            if (random.nextFloat() < 0.15f / (float)nearbyPlayers) {
                ElementalRealmHandler.spawnMob(player, (EntityType<? extends Mob>)((EntityType)MysticismEntityTypes.RADIANT_LION.get()), 1, 2);
            }
        }
    }
}

