/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism")
public abstract class GardenerHandler {
    @SubscribeEvent
    public static void onConsumeFood(LivingEntityUseItemEvent.Finish event) {
        CompoundTag itemTag;
        ItemStack item = event.getItem();
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().f_46443_ && item.m_41614_() && (itemTag = item.m_41784_()).m_128471_("GardenerBlessed")) {
            GardenerHandler.applyEffects(entity, itemTag);
        }
    }

    @SubscribeEvent
    public static void onFeedTameable(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!player.m_9236_().f_46443_ && target instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)target;
            if (stack.m_41614_()) {
                if (tamable.m_27593_() || tamable.m_146764_() > 0) {
                    return;
                }
                CompoundTag itemTag = stack.m_41784_();
                if (itemTag.m_128471_("GardenerBlessed")) {
                    boolean isInjured;
                    boolean isBreedingItem = tamable.m_6898_(stack);
                    boolean bl = isInjured = tamable.m_21223_() < tamable.m_21233_();
                    if (isBreedingItem || isInjured) {
                        GardenerHandler.applyEffects((LivingEntity)tamable, itemTag);
                    }
                }
            }
        }
    }

    private static void applyEffects(LivingEntity entity, CompoundTag itemTag) {
        if (itemTag.m_128471_("DaytimeBlessing")) {
            if (itemTag.m_128471_("GardenerMastery")) {
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 6000, 4, false, true, true));
            } else {
                entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 3600, 2, false, true, true));
            }
        } else if (itemTag.m_128471_("NoonBlessing")) {
            if (itemTag.m_128471_("GardenerMastery")) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 3600, 1, false, true, true));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 3600, 0, false, true, true));
            }
        } else if (itemTag.m_128471_("NightBlessing")) {
            if (itemTag.m_128471_("GardenerMastery")) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 6000, 4, false, true, true));
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.STEP_AUGMENTATION.get(), 6000, 5, false, true, true));
            } else {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 3600, 2, false, true, true));
                entity.m_7292_(new MobEffectInstance((MobEffect)MysticismMobEffects.STEP_AUGMENTATION.get(), 3600, 3, false, true, true));
            }
        }
    }
}

