/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.util.TimerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism")
public class MephistoHandler {
    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CompoundTag tag;
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_() && event.getTo() == MysticismDimensions.FANTASY_WORLD && (tag = player.getPersistentData()).m_128471_("InsideFantasyWorld")) {
            player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.fantasy_world.entered_fantasy_world").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            TimerUtils.Timer timer = TimerUtils.getOrCreateTimer("MephistoStartFantasy");
            timer.start(3600, () -> {
                MephistoHandler.handleExit(player);
                timer.stop();
                timer.reset();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel fantasyWorld = server.m_129880_(MysticismDimensions.FANTASY_WORLD);
        CompoundTag tag = player.getPersistentData();
        if (tag.m_128471_("InsideFantasyWorld") && player.m_9236_().m_46472_() != MysticismDimensions.FANTASY_WORLD) {
            if (fantasyWorld == null) {
                player.m_5661_((Component)Component.m_237115_((String)"error.dimension.not_found"), false);
                return;
            }
            SkillHelper.moveAcrossDimensionTo((Entity)player, (double)53.0, (double)-17.0, (double)25.0, (float)1.0f, (float)1.0f, (ServerLevel)fantasyWorld);
        }
    }

    public static void loadFantasyWorldStructures(ServerLevel serverLevel) {
        if (serverLevel.m_46472_() != MysticismDimensions.FANTASY_WORLD) {
            throw new IllegalArgumentException("This method can only be used to load the Fantasy World dimension.");
        }
        MinecraftServer server = serverLevel.m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel level = server.m_129880_(MysticismDimensions.FANTASY_WORLD);
        if (level != null) {
            StructureTemplateManager manager = level.m_215082_();
            StructurePlaceSettings settings = new StructurePlaceSettings();
            List<StructureTemplate> templates = MephistoHandler.loadTemplates(manager);
            for (StructureTemplate template : templates) {
                int i = templates.indexOf(template);
                BlockPos placePos = switch (i) {
                    case 0 -> new BlockPos(26, -20, 9);
                    case 1 -> new BlockPos(26, -20, -4);
                    case 2 -> new BlockPos(73, -19, 3);
                    default -> new BlockPos(0, 0, 0);
                };
                template.m_230328_((ServerLevelAccessor)level, placePos, placePos, settings, level.f_46441_, 3);
            }
        }
    }

    private static List<StructureTemplate> loadTemplates(StructureTemplateManager manager) {
        ArrayList<StructureTemplate> templates = new ArrayList<StructureTemplate>();
        for (int i = 0; i < 18; ++i) {
            String path = switch (i) {
                case 0 -> "fantasy_world/fantasy_world_1";
                case 1 -> "fantasy_world/fantasy_world_2";
                case 2 -> "fantasy_world/fantasy_world_3";
                default -> "";
            };
            ResourceLocation resourceLocation = new ResourceLocation("trmysticism", path);
            templates.add(manager.m_230359_(resourceLocation));
        }
        return templates;
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        CompoundTag tag = event.getEntity().getPersistentData();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (tag.m_128471_("InsideFantasyWorld")) {
                MephistoHandler.handleExit((Player)player2);
            }
        }
    }

    private static void handleExit(Player player) {
        ServerLevel currentLevel = (ServerLevel)player.m_9236_();
        CompoundTag tag = player.getPersistentData();
        CompoundTag positionsTag = tag.m_128469_("OriginalPositions");
        for (String entityKey : positionsTag.m_128431_()) {
            UUID entityUUID = UUID.fromString(entityKey);
            Entity entity = currentLevel.m_8791_(entityUUID);
            if (entity == null) continue;
            CompoundTag entityData = positionsTag.m_128469_(entityKey);
            BlockPos position = new BlockPos(entityData.m_128459_("x"), entityData.m_128459_("y"), entityData.m_128459_("z"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(entityData.m_128461_("dimension")));
            if (!entity.f_19853_.m_46472_().equals((Object)dimension)) {
                ServerLevel targetLevel = player.m_20194_().m_129880_(dimension);
                if (targetLevel == null) continue;
                SkillHelper.moveAcrossDimensionTo((Entity)entity, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)1.0f, (float)1.0f, (ServerLevel)targetLevel);
                continue;
            }
            entity.m_6034_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
        }
        tag.m_128473_("OriginalPositions");
        tag.m_128379_("InsideFantasyWorld", false);
        tag.m_128473_("InsideFantasyWorld");
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.getPersistentData().m_128441_("IsMarkedByMephisto")) {
            entity.getPersistentData().m_128473_("IsMarkedByMephisto");
        }
    }

    @SubscribeEvent
    public static void potionApplicableEvent(MobEffectEvent.Applicable event) {
        MobEffect effect;
        CompoundTag tag;
        if (!SkillUtils.hasSkill((Entity)event.getEntity(), (ManasSkill)((ManasSkill)UltimateSkills.MEPHISTO.get()))) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
        Optional instance = storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get());
        if (instance.isPresent() && (tag = ((ManasSkillInstance)instance.get()).getOrCreateTag()).m_128471_("InFantasyWorld") && ((effect = event.getEffectInstance().m_19544_()).m_19483_() == MobEffectCategory.HARMFUL || event.getEffectInstance().m_19544_() == TensuraMobEffects.INFINITE_IMPRISONMENT.get())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (level.m_46472_() == MysticismDimensions.FANTASY_WORLD) {
            event.getAffectedBlocks().clear();
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().m_9236_();
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)event.getPlayer());
        Optional instance = storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get());
        if (level.m_46472_() == MysticismDimensions.FANTASY_WORLD) {
            CompoundTag tag;
            if (instance.isPresent() && (tag = ((ManasSkillInstance)instance.get()).getOrCreateTag()).m_128471_("InFantasyWorld")) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyBlock(LivingDestroyBlockEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.m_46472_() == MysticismDimensions.FANTASY_WORLD) {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
            Optional instance = storage.getSkill((ManasSkill)UltimateSkills.MEPHISTO.get());
            if (instance.isPresent()) {
                CompoundTag tag = ((ManasSkillInstance)instance.get()).getOrCreateTag();
                if (tag.m_128471_("InFantasyWorld")) {
                    event.setCanceled(false);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }
}

