/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import io.github.Memoires.trmysticism.ability.MysticismSkillInstance;
import io.github.Memoires.trmysticism.event.OnSkillGainMasteryEvent;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MysticismSkillHandler {
    @SubscribeEvent
    public static void onGainMastery(OnSkillGainMasteryEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
        List<ManasSkillInstance> list = List.copyOf(skillStorage.getLearnedSkills());
        if (!list.isEmpty()) {
            for (ManasSkillInstance copy : list) {
                Object t;
                Optional optional = skillStorage.getSkill(copy.getSkill());
                if (!optional.isPresent() || !((t = optional.get()) instanceof MysticismSkillInstance)) continue;
                MysticismSkillInstance instance = (MysticismSkillInstance)((Object)t);
                instance.onGainMastery(event.getEntity(), event);
            }
            skillStorage.syncChanges();
        }
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)source);
            for (ManasSkillInstance copy : List.copyOf(skillStorage.getLearnedSkills())) {
                MysticismSkillInstance instance;
                Object t;
                Optional optional = skillStorage.getSkill(copy.getSkill());
                if (!optional.isPresent() || !((t = optional.get()) instanceof MysticismSkillInstance) || !(instance = (MysticismSkillInstance)((Object)t)).canInteractSkill(source)) continue;
                instance.onKillEntity(source, event.getEntity(), event);
            }
            skillStorage.syncChanges();
        }
    }

    @SubscribeEvent
    public static void onHurtEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            SkillStorage ownerStorage;
            List<ManasSkillInstance> ownerSkills;
            float dmg;
            MysticismSkillInstance instance;
            Object t;
            Optional optional;
            LivingEntity source = (LivingEntity)entity;
            LivingEntity target = event.getEntity();
            LivingEntity owner = SkillHelper.getSubordinateOwner((LivingEntity)target);
            SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)target);
            SkillStorage sourceStorage = SkillAPI.getSkillsFrom((Entity)source);
            List<ManasSkillInstance> sourceSkills = List.copyOf(sourceStorage.getLearnedSkills());
            List<ManasSkillInstance> targetSkills = List.copyOf(targetStorage.getLearnedSkills());
            if (!sourceSkills.isEmpty()) {
                for (ManasSkillInstance copy : targetSkills) {
                    optional = targetStorage.getSkill(copy.getSkill());
                    if (!optional.isPresent() || !((t = optional.get()) instanceof MysticismSkillInstance) || !(instance = (MysticismSkillInstance)((Object)t)).canInteractSkill(target) || !((dmg = target.m_21223_() - event.getAmount()) <= 0.0f)) continue;
                    instance.onSelfHit0HP(source, target, event);
                }
                targetStorage.syncChanges();
            }
            if (!sourceSkills.isEmpty()) {
                for (ManasSkillInstance copy : sourceSkills) {
                    optional = sourceStorage.getSkill(copy.getSkill());
                    if (!optional.isPresent() || !((t = optional.get()) instanceof MysticismSkillInstance) || !(instance = (MysticismSkillInstance)((Object)t)).canInteractSkill(source) || !((dmg = target.m_21223_() - event.getAmount()) <= 0.0f)) continue;
                    instance.onTargetHit0HP(source, target, event);
                }
                sourceStorage.syncChanges();
            }
            if (owner != null && !(ownerSkills = List.copyOf((ownerStorage = SkillAPI.getSkillsFrom((Entity)owner)).getLearnedSkills())).isEmpty()) {
                for (ManasSkillInstance copy : ownerSkills) {
                    Object t2;
                    Optional optional2 = ownerStorage.getSkill(copy.getSkill());
                    if (!optional2.isPresent() || !((t2 = optional2.get()) instanceof MysticismSkillInstance)) continue;
                    MysticismSkillInstance instance2 = (MysticismSkillInstance)((Object)t2);
                    dmg = target.m_21223_() - event.getAmount();
                    if (!(dmg <= 0.0f)) continue;
                    instance2.onSubordinateHit0HP(source, target, owner, event);
                }
                ownerStorage.syncChanges();
            }
        }
    }

    @SubscribeEvent
    public static void syncData(PlayerEvent.PlayerLoggedInEvent event) {
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)event.getEntity());
        List<ManasSkillInstance> list = List.copyOf(skillStorage.getLearnedSkills());
        if (!list.isEmpty()) {
            for (ManasSkillInstance copy : list) {
                Object t;
                Optional optional = skillStorage.getSkill(copy.getSkill());
                if (!optional.isPresent() || !((t = optional.get()) instanceof MysticismSkillInstance)) continue;
                MysticismSkillInstance instance = (MysticismSkillInstance)((Object)t);
                instance.setData(instance.getOrCreateTag().m_128469_("data"));
                instance.getOrCreateTag().m_128365_("data", (Tag)instance.getData());
            }
            skillStorage.syncChanges();
        }
    }

    @SubscribeEvent
    public static void attachData(UnlockSkillEvent event) {
        MysticismSkillInstance instance;
        ManasSkillInstance manasSkillInstance = event.getSkillInstance();
        if (manasSkillInstance instanceof MysticismSkillInstance && (instance = (MysticismSkillInstance)manasSkillInstance).getData() != null) {
            instance.getOrCreateTag().m_128365_("data", (Tag)instance.getData());
        }
    }
}

