/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.event.SkillActivationEvent;
import com.github.manasmods.manascore.api.skills.event.SkillReleaseEvent;
import io.github.Memoires.trmysticism.ability.MysticismSkill;
import io.github.Memoires.trmysticism.event.OnSkillGainMasteryEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OnSkillGainMasteryHandler {
    private static int preFiredMastery;
    private static int postFiredMastery;

    @SubscribeEvent
    public static void onSkillActivate(SkillActivationEvent event) {
        ManasSkillInstance instance = event.getSkillInstance();
        preFiredMastery = instance.getMastery();
    }

    @SubscribeEvent
    public static void onSkillRelease(SkillReleaseEvent event) {
        OnSkillGainMasteryEvent.Pre preEvent;
        ManasSkillInstance instance = event.getSkillInstance();
        if (instance.getSkill() instanceof MysticismSkill) {
            return;
        }
        postFiredMastery = instance.getMastery();
        int gainedMastery = postFiredMastery - preFiredMastery;
        if (preFiredMastery < postFiredMastery && !MinecraftForge.EVENT_BUS.post((Event)(preEvent = new OnSkillGainMasteryEvent.Pre(instance, postFiredMastery, preFiredMastery, gainedMastery, (LivingEntity)event.getEntity())))) {
            postFiredMastery = preFiredMastery + preEvent.getGainedMastery();
            OnSkillGainMasteryEvent skillGainMasteryEvent = new OnSkillGainMasteryEvent(instance, postFiredMastery, preFiredMastery, (LivingEntity)event.getEntity());
            MinecraftForge.EVENT_BUS.post((Event)skillGainMasteryEvent);
            instance.setMastery(skillGainMasteryEvent.getNewMastery());
        }
    }
}

