/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.attribute.ManasCoreAttributes;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import io.github.Memoires.trmysticism.ability.skill.unique.PlundererSkill;
import io.github.Memoires.trmysticism.entity.skill.ShadowSoulEntity;
import io.github.Memoires.trmysticism.entity.skill.ShadowSubordinateEntity;
import io.github.Memoires.trmysticism.registry.entity.MysticismEntityTypes;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VaingloryHandler {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent e) {
        Entity source = e.getSource().m_7639_();
        LivingEntity entity = e.getEntity();
        if (entity instanceof Player) {
            return;
        }
        if (source instanceof Player) {
            Player player = (Player)source;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = entity;
                if (!(entity instanceof ShadowSubordinateEntity)) {
                    boolean hasPlunderer = SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)UniqueSkills.PLUNDERER.get()));
                    boolean hasVainglory = SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)UniqueSkills.VAINGLORY.get()));
                    boolean hasLaverna = SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)UltimateSkills.LAVERNA.get()));
                    boolean plundererToggled = hasPlunderer && SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)UniqueSkills.PLUNDERER.get()));
                    boolean vaingloryToggled = hasVainglory && SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)UniqueSkills.VAINGLORY.get()));
                    int chance = 25;
                    if (hasLaverna && !livingEntity.m_6095_().getTags().toList().contains(TensuraTags.EntityTypes.NO_MIND_CONTROL) && !livingEntity.m_6095_().equals(TensuraEntityTypes.CLONE_DEFAULT.get()) && !livingEntity.m_6095_().equals(TensuraEntityTypes.CLONE_SLIM.get())) {
                        Level level = player.m_9236_();
                        livingEntity.f_20916_ = 0;
                        livingEntity.f_20917_ = 0;
                        Optional lavernaInstance = SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)UltimateSkills.LAVERNA.get());
                        if (lavernaInstance.isPresent() && !((ManasSkillInstance)lavernaInstance.get()).getOrCreateTag().m_128471_("ShadowGarden")) {
                            return;
                        }
                        CompoundTag tag = ((ManasSkillInstance)lavernaInstance.get()).getOrCreateTag();
                        ShadowSoulEntity shadowSoulEntity = new ShadowSoulEntity(livingEntity.f_19853_, new BlockPos(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_()));
                        shadowSoulEntity.m_20084_(UUID.randomUUID());
                        shadowSoulEntity.setOriginalMobData(livingEntity);
                        CompoundTag mobData = shadowSoulEntity.getOriginalMobData();
                        LivingEntity originalEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, boy -> boy);
                        if (originalEntity != null && !(originalEntity instanceof CloneEntity)) {
                            double playerMP;
                            double magiculeCost = TensuraEPCapability.getEP((LivingEntity)originalEntity) * 0.05;
                            if (magiculeCost > (playerMP = TensuraPlayerCapability.getMagicule((Player)player))) {
                                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.plunderer.shadow_warrior.fail").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                            } else {
                                tag.m_128347_("SubordinateMPCost", magiculeCost);
                                TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                                    cap.setMagicule(cap.getMagicule() - magiculeCost);
                                    TensuraPlayerCapability.sync((Player)player);
                                });
                                ShadowSubordinateEntity shadowEntity = new ShadowSubordinateEntity(originalEntity.f_19853_, new BlockPos(originalEntity.m_20185_(), originalEntity.m_20186_(), originalEntity.m_20189_()), originalEntity);
                                shadowEntity.setOriginalMobData(originalEntity);
                                shadowEntity.m_21828_(player);
                                shadowEntity.m_217045_();
                                CompoundTag tags = shadowEntity.getPersistentData();
                                tags.m_128379_("NO_EP_PLUNDER", true);
                                tags.m_128379_("NO_SKILL_PLUNDER", true);
                                tags.m_128379_("no_loot", true);
                                shadowEntity.m_6034_(originalEntity.m_20185_(), originalEntity.m_20186_(), originalEntity.m_20189_());
                                shadowEntity.m_6593_(originalEntity.m_7770_());
                                shadowEntity.deserializeNBT(originalEntity.serializeNBT());
                                shadowEntity.m_20084_(UUID.randomUUID());
                                VaingloryHandler.setStats(originalEntity, shadowEntity);
                                shadowEntity.setHeight(originalEntity.m_20206_());
                                shadowEntity.setWidth(originalEntity.m_20205_());
                                if (level.m_7967_((Entity)shadowEntity)) {
                                    VaingloryHandler.copyAttributes(originalEntity, (LivingEntity)shadowEntity);
                                    VaingloryHandler.copySkills(originalEntity, shadowEntity);
                                    shadowSoulEntity.m_146870_();
                                    shadowEntity.m_21153_(shadowEntity.m_21233_());
                                    TensuraEPCapability.getFrom((LivingEntity)shadowEntity).ifPresent(cap -> cap.setMajin(true));
                                    TensuraEPCapability.sync((LivingEntity)shadowEntity);
                                    shadowEntity.f_19853_.m_6269_(null, (Entity)shadowEntity, SoundEvents.f_12513_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)shadowEntity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
                                }
                            }
                        }
                        return;
                    }
                    if (!plundererToggled && !vaingloryToggled) {
                        return;
                    }
                    if (vaingloryToggled) {
                        chance = 100;
                    } else if (plundererToggled && SkillUtils.isSkillMastered((LivingEntity)player, (ManasSkill)((ManasSkill)UniqueSkills.PLUNDERER.get()))) {
                        chance = 50;
                    }
                    if (!livingEntity.m_6095_().equals(MysticismEntityTypes.SHADOW_SUBORDINATE.get()) && !livingEntity.m_6095_().toString().contains("Dummy")) {
                        if (PlundererSkill.isMindControlFailed((LivingEntity)player, livingEntity, entity.f_19853_)) {
                            return;
                        }
                        livingEntity.f_20916_ = 0;
                        livingEntity.f_20917_ = 0;
                        ShadowSoulEntity shadowSoulEntity = new ShadowSoulEntity(livingEntity.f_19853_, new BlockPos(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_()));
                        shadowSoulEntity.m_20084_(UUID.randomUUID());
                        shadowSoulEntity.setOriginalMobData(livingEntity);
                        livingEntity.f_19853_.m_7967_((Entity)shadowSoulEntity);
                        if (livingEntity.m_217043_().m_188503_(100) < chance) {
                            livingEntity.f_19853_.m_7967_((Entity)shadowSoulEntity);
                        }
                    }
                }
            }
        }
    }

    private static void setStats(LivingEntity originalEntity, ShadowSubordinateEntity shadowSubordinate) {
        shadowSubordinate.m_21153_(originalEntity.m_21233_());
        shadowSubordinate.m_7910_(originalEntity.m_6113_());
        TensuraEPCapability.setSpiritualHealth((LivingEntity)shadowSubordinate, (double)TensuraEPCapability.getSpiritualHealth((LivingEntity)originalEntity));
        TensuraEPCapability.setLivingEP((LivingEntity)shadowSubordinate, (double)TensuraEPCapability.getEP((LivingEntity)originalEntity));
    }

    private static void copyAttributes(LivingEntity originalEntity, LivingEntity shadowEntity) {
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22280_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22280_)) {
            shadowEntity.m_21051_(Attributes.f_22280_).m_22100_(originalEntity.m_21133_(Attributes.f_22280_));
        }
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22276_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22276_)) {
            shadowEntity.m_21051_(Attributes.f_22276_).m_22100_(originalEntity.m_21133_(Attributes.f_22276_));
        }
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22281_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22281_)) {
            shadowEntity.m_21051_(Attributes.f_22281_).m_22100_(originalEntity.m_21133_(Attributes.f_22281_));
        }
        shadowEntity.m_21051_(Attributes.f_22277_).m_22100_(32.0);
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22278_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22278_)) {
            shadowEntity.m_21051_(Attributes.f_22278_).m_22100_(originalEntity.m_21133_(Attributes.f_22278_));
        }
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22279_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22279_)) {
            shadowEntity.m_21051_(Attributes.f_22279_).m_22100_(originalEntity.m_21133_(Attributes.f_22279_));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ForgeMod.SWIM_SPEED.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ForgeMod.SWIM_SPEED.get())) {
            shadowEntity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(originalEntity.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()));
        }
        if (originalEntity.m_21204_().m_22171_(Attributes.f_22284_) && shadowEntity.m_21204_().m_22171_(Attributes.f_22284_)) {
            shadowEntity.m_21051_(Attributes.f_22284_).m_22100_(originalEntity.m_21133_(Attributes.f_22284_));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.CRIT_MULTIPLIER.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.CRIT_CHANCE.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.FLYING_SPEED_MULTIPLIER.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.FLYING_SPEED_MULTIPLIER.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.FLYING_SPEED_MULTIPLIER.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.FLYING_SPEED_MULTIPLIER.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.MINING_SPEED_MULTIPLIER.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.MINING_SPEED_MULTIPLIER.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.MINING_SPEED_MULTIPLIER.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.MINING_SPEED_MULTIPLIER.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.SPRINTING_SPEED_MULTIPLIER.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.JUMP_POWER.get()) && shadowEntity.m_21204_().m_22171_((Attribute)ManasCoreAttributes.JUMP_POWER.get())) {
            shadowEntity.m_21051_((Attribute)ManasCoreAttributes.JUMP_POWER.get()).m_22100_(originalEntity.m_21133_((Attribute)ManasCoreAttributes.JUMP_POWER.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()) && shadowEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get())) {
            shadowEntity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()).m_22100_(originalEntity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()) && shadowEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get())) {
            shadowEntity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()).m_22100_(originalEntity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()) && shadowEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.MAX_AURA.get())) {
            shadowEntity.m_21051_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()).m_22100_(originalEntity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get()));
        }
        if (originalEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.SIZE.get()) && shadowEntity.m_21204_().m_22171_((Attribute)TensuraAttributeRegistry.SIZE.get())) {
            shadowEntity.m_21051_((Attribute)TensuraAttributeRegistry.SIZE.get()).m_22100_(originalEntity.m_21133_((Attribute)TensuraAttributeRegistry.SIZE.get()));
        }
    }

    private static void copySkills(LivingEntity originalEntity, ShadowSubordinateEntity shadowSubordinate) {
        SkillStorage originalStorage = SkillAPI.getSkillsFrom((Entity)originalEntity);
        SkillStorage targetStorage = SkillAPI.getSkillsFrom((Entity)shadowSubordinate);
        for (ManasSkillInstance instances : originalStorage.getLearnedSkills()) {
            if (instances.isTemporarySkill() || instances.getMastery() < 0) continue;
            targetStorage.learnSkill(instances);
        }
    }
}

