/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VicielHandler {
    private static final double DETECTION_RADIUS = 3.0;

    @SubscribeEvent
    public static void onMobTargetPlayer(LivingChangeTargetEvent event) {
        LivingEntity target = event.getNewTarget();
        LivingEntity mob = event.getEntity();
        if (target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            if (mob instanceof Mob && VicielHandler.isPlayerHidden(player) && !VicielHandler.isPlayerTooClose(player, mob)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean isPlayerHidden(ServerPlayer player) {
        return SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)UltimateSkills.VICIEL.get()));
    }

    private static boolean isPlayerTooClose(ServerPlayer player, LivingEntity mob) {
        return (double)player.m_20270_((Entity)mob) < 3.0;
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)player);
            if (skillStorage == null) {
                return;
            }
            ArrayList playersSkills = new ArrayList(skillStorage.getLearnedSkills());
            for (ManasSkillInstance skillInstance : playersSkills) {
                CompoundTag skillTag = skillInstance.getOrCreateTag();
                String skillId = skillInstance.getSkill().getRegistryName().toString();
                boolean isResSkill = skillTag.m_128471_("resSkill");
                boolean isVicSkill = skillTag.m_128471_("vicSkill");
                boolean alreadyHas = skillTag.m_128471_("alreadyHas");
                boolean notLearned = skillTag.m_128471_("notLearned");
                if (notLearned) {
                    int learningPoint = skillTag.m_128451_("learningPoint");
                    skillInstance.setMastery(learningPoint);
                    skillTag.m_128473_("notLearned");
                    skillTag.m_128473_("vicSkill");
                    skillTag.m_128473_("timeAdded");
                    skillTag.m_128473_("learningPoint");
                    skillStorage.syncChanges();
                    return;
                }
                if (isVicSkill && !alreadyHas) {
                    skillTag.m_128473_("alreadyHas");
                    skillTag.m_128473_("vicSkill");
                    skillTag.m_128473_("timeAdded");
                    skillTag.m_128473_("resSkill");
                    skillTag.m_128473_("resMastery");
                    skillStorage.forgetSkill(skillInstance);
                    skillStorage.syncChanges();
                    continue;
                }
                if (!isResSkill) continue;
                int resMastery = skillTag.m_128451_("resMastery");
                skillInstance.setMastery(resMastery);
                skillTag.m_128473_("alreadyHas");
                skillTag.m_128473_("vicSkill");
                skillTag.m_128473_("timeAdded");
                skillTag.m_128473_("resSkill");
                skillTag.m_128473_("resMastery");
                skillStorage.syncChanges();
            }
        }
    }
}

