/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.handlers.client;

import com.github.manasmods.tensura.data.TensuraTags;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.Memoires.trmysticism.registry.effects.MysticismMobEffects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientBlockOutlineHandler {
    private static PoseStack poseStack;
    private static BufferBuilder bufferBuilder;

    @SubscribeEvent
    public static void renderBlockOutline(RenderLevelStageEvent event) {
        LocalPlayer player;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && (player = Minecraft.m_91087_().f_91074_) != null) {
            MobEffectInstance dangerDetection = player.m_21124_((MobEffect)MysticismMobEffects.ENHANCED_DANGER_DETECTION.get());
            MobEffectInstance treasureDetection = player.m_21124_((MobEffect)MysticismMobEffects.TREASURE_DETECTION.get());
            if (dangerDetection != null) {
                ClientBlockOutlineHandler.highLightBlocks(event, player, 15, state -> state.m_204336_(TensuraTags.Blocks.TRAP_BLOCKS), new Vec3(0.89, 0.1, 0.1));
            }
            if (treasureDetection != null) {
                ClientBlockOutlineHandler.highLightBlocks(event, player, 15, state -> state.m_204336_(TensuraTags.Blocks.TREASURE_BLOCKS), new Vec3(1.0, 1.0, 0.0));
                ClientBlockOutlineHandler.highLightBlocks(event, player, 30, state -> state.m_204336_(TensuraTags.Blocks.ORES_MAGIC), new Vec3(200.0, 100.0, 150.0));
                ClientBlockOutlineHandler.highLightBlocks(event, player, 30, state -> state.m_204336_(TensuraTags.Blocks.ORES_SILVER), new Vec3(192.0, 192.0, 192.0));
                ClientBlockOutlineHandler.highLightBlocks(event, player, 30, state -> state.m_60713_(Blocks.f_50722_), new Vec3(72.0, 60.0, 50.0));
            }
            poseStack = null;
            bufferBuilder = null;
        }
    }

    private static void highLightBlocks(RenderLevelStageEvent event, LocalPlayer player, int radius, Predicate<BlockState> predicate, Vec3 color) {
        poseStack = event.getPoseStack();
        poseStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69465_();
        Tesselator tesselator = Tesselator.m_85913_();
        bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        ClientBlockOutlineHandler.drawLines(player, radius, predicate, color);
        tesselator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.m_69482_();
        RenderType.m_110463_().m_110188_();
    }

    private static void drawLines(LocalPlayer localPlayer, int radius, Predicate<BlockState> predicate, Vec3 color) {
        Vec3 camera = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        BlockPos startPosition = localPlayer.m_20183_();
        ChunkPos currentChunkPosition = new ChunkPos(startPosition);
        LevelChunk currentChunk = null;
        int minChunkX = startPosition.m_123341_() - radius;
        int maxChunkX = startPosition.m_123341_() + radius;
        int minChunkY = Math.max(localPlayer.m_9236_().m_141937_(), startPosition.m_123342_() - radius);
        int maxChunkY = Math.min(localPlayer.m_9236_().m_151558_(), startPosition.m_123342_() + radius);
        int minChunkZ = startPosition.m_123343_() - radius;
        int maxChunkZ = startPosition.m_123343_() + radius;
        boolean foundSection = false;
        BlockPos.MutableBlockPos mutablePosition = BlockPos.f_121853_.m_122032_();
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                int sectionX = SectionPos.m_123171_((int)x);
                int sectionZ = SectionPos.m_123171_((int)z);
                if (currentChunk == null || currentChunkPosition.f_45578_ != sectionX || currentChunkPosition.f_45579_ != sectionZ) {
                    currentChunkPosition = new ChunkPos(sectionX, sectionZ);
                    currentChunk = localPlayer.m_9236_().m_6325_(sectionX, sectionZ);
                }
                foundSection = false;
                for (int y = maxChunkY; y >= minChunkY; --y) {
                    foundSection = true;
                    mutablePosition.m_122178_(x, y, z);
                    BlockState state = currentChunk.m_8055_((BlockPos)mutablePosition);
                    if (!predicate.test(state)) continue;
                    float xMin = (float)((double)x - camera.m_7096_());
                    float yMin = (float)((double)y - camera.m_7098_());
                    float zMin = (float)((double)z - camera.m_7094_());
                    float xMax = (float)((double)(1 + x) - camera.m_7096_());
                    float yMax = (float)((double)(1 + y) - camera.m_7098_());
                    float zMax = (float)((double)(1 + z) - camera.m_7094_());
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)bufferBuilder, (double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax, (float)((float)color.m_7096_()), (float)((float)color.m_7098_()), (float)((float)color.m_7094_()), (float)1.0f);
                }
                if (foundSection || z == maxChunkZ) continue;
                z = Math.min(maxChunkZ, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)z) + 1)));
            }
            if (foundSection || x == maxChunkX) continue;
            x = Math.min(maxChunkX, SectionPos.m_123223_((int)(SectionPos.m_123171_((int)x) + 1)));
        }
    }
}

