/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.item.custom;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.TensuraRarity;
import io.github.Memoires.trmysticism.race.fallenAngel.FallenArchangelRace;
import io.github.Memoires.trmysticism.race.fallenAngel.FallenCherubRace;
import io.github.Memoires.trmysticism.race.fallenAngel.FallenGreaterAngelRace;
import io.github.Memoires.trmysticism.race.fallenAngel.FallenLesserAngelRace;
import io.github.Memoires.trmysticism.race.fallenAngel.FallenSeraphimRace;
import io.github.Memoires.trmysticism.registry.race.MysticismRaces;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DarknessCoreItem
extends Item {
    private static final Set<UUID> evolvedThisTick = new HashSet<UUID>();
    private static final Set<UUID> messageSentThisTick = new HashSet<UUID>();
    public boolean hasTransform = false;
    public boolean hasMagicTransform = false;
    public int transformMastery;
    public int magicTransformMastery;

    public DarknessCoreItem() {
        super(new Item.Properties().m_41491_(TensuraCreativeTab.MISCELLANEOUS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.trmysticism.darkness_core").m_130940_(ChatFormatting.DARK_PURPLE));
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        if (player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_150110_().f_35937_ && !(playerRace instanceof FallenLesserAngelRace)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pLivingEntity, (ParticleOptions)ParticleTypes.f_123808_);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        Player player = (Player)entity;
        TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
        Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)entity);
        IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (!(playerRace instanceof FallenLesserAngelRace) && useTicks >= 10) {
            player.m_213846_((Component)Component.m_237113_((String)"You can't use that...").m_130940_(ChatFormatting.DARK_PURPLE));
            return;
        }
        if (useTicks >= 10 && entity instanceof Player) {
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                pStack.m_41774_(1);
            }
            if (playerRace instanceof FallenLesserAngelRace) {
                if (playerRace.getClass() == FallenLesserAngelRace.class) {
                    DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.LESSER_FALLEN);
                } else if (playerRace.getClass() == FallenGreaterAngelRace.class) {
                    DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.GREATER_FALLEN);
                } else if (playerRace.getClass() == FallenArchangelRace.class) {
                    DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.ARCHFALLEN);
                } else if (playerRace.getClass() == FallenCherubRace.class) {
                    DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_LORD);
                } else if (playerRace.getClass() == FallenSeraphimRace.class) {
                    DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN);
                }
            }
            this.inverseAttribute(player);
            entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11689_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123810_, (double)0.0);
        }
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity target, LivingEntity pAttacker) {
        if (target.m_6084_() && target.m_7307_((Entity)pAttacker)) {
            Player player;
            target.f_19802_ = 0;
            if (pAttacker instanceof Player) {
                player = (Player)pAttacker;
                if (!player.m_150110_().f_35937_) {
                    player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                    pStack.m_41774_(1);
                }
            }
            if (target instanceof Player) {
                player = (Player)target;
                TensuraPlayerCapability.getFrom((Player)player).ifPresent(data -> data.setTrackedEvolution(player, (Race)null));
                Race playerRace = TensuraPlayerCapability.getRace((LivingEntity)player);
                IForgeRegistry raceRegistry = (IForgeRegistry)TensuraRaces.RACE_REGISTRY.get();
                if (player instanceof Player) {
                    if (!player.m_150110_().f_35937_) {
                        player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                        pStack.m_41774_(1);
                    }
                    if (playerRace instanceof FallenLesserAngelRace) {
                        if (playerRace.getClass() == FallenLesserAngelRace.class) {
                            DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.LESSER_FALLEN);
                        } else if (playerRace.getClass() == FallenGreaterAngelRace.class) {
                            DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.GREATER_FALLEN);
                        } else if (playerRace.getClass() == FallenArchangelRace.class) {
                            DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.ARCHFALLEN);
                        } else if (playerRace.getClass() == FallenCherubRace.class) {
                            DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN_LORD);
                        } else if (playerRace.getClass() == FallenSeraphimRace.class) {
                            DarknessCoreItem.evolvePlayerIntoFallen(player, (IForgeRegistry<Race>)raceRegistry, MysticismRaces.FALLEN);
                        }
                    }
                    this.inverseAttribute(player);
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11689_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)player, (ParticleOptions)ParticleTypes.f_123810_, (double)0.0);
                }
            }
            return true;
        }
        return super.m_7579_(pStack, target, pAttacker);
    }

    private static void evolvePlayerIntoFallen(Player player, IForgeRegistry<Race> registry, ResourceLocation targetRaceKey) {
        UUID playerId = player.m_20148_();
        Race targetRace = (Race)registry.getValue(targetRaceKey);
        if (targetRace != null) {
            RaceHelper.evolveRace((Player)player, (Race)targetRace, (boolean)true, (boolean)true);
        }
        if (!messageSentThisTick.contains(playerId)) {
            player.m_213846_((Component)Component.m_237113_((String)"You have completely lost your connection to the light attribute...").m_130940_(ChatFormatting.DARK_PURPLE));
            messageSentThisTick.add(playerId);
        }
        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11689_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void inverseAttribute(Player player) {
        boolean hasTransform = false;
        boolean hasMagicTransform = false;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        if (SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)IntrinsicSkills.LIGHT_TRANSFORM.get())) && !SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)IntrinsicSkills.DARKNESS_TRANSFORM.get()))) {
            list.add((TensuraSkill)IntrinsicSkills.LIGHT_TRANSFORM.get());
            hasTransform = true;
            this.transformMastery = storage.getSkill((ManasSkill)IntrinsicSkills.LIGHT_TRANSFORM.get()).map(instance -> instance.getMastery()).orElse(0);
        }
        if (SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.MAGIC_LIGHT_TRANSFORM.get())) && !SkillUtils.hasSkill((Entity)player, (ManasSkill)((ManasSkill)ExtraSkills.MAGIC_DARKNESS_TRANSFORM.get()))) {
            list.add((TensuraSkill)ExtraSkills.MAGIC_LIGHT_TRANSFORM.get());
            hasMagicTransform = true;
            this.magicTransformMastery = storage.getSkill((ManasSkill)ExtraSkills.MAGIC_LIGHT_TRANSFORM.get()).map(instance -> instance.getMastery()).orElse(0);
        }
        list.forEach(skill -> SkillAPI.getSkillsFrom((Entity)player).forgetSkill((ManasSkill)skill));
        ArrayList<TensuraSkill> listLearn = new ArrayList<TensuraSkill>();
        if (hasTransform) {
            listLearn.add((TensuraSkill)IntrinsicSkills.DARKNESS_TRANSFORM.get());
            listLearn.add((TensuraSkill)SpiritualMagics.DARKNESS.get());
            listLearn.add((TensuraSkill)SpiritualMagics.DARK_CUBE.get());
            listLearn.add((TensuraSkill)SpiritualMagics.SHADOW_BIND.get());
        }
        if (hasMagicTransform) {
            listLearn.add((TensuraSkill)ExtraSkills.MAGIC_DARKNESS_TRANSFORM.get());
            listLearn.add((TensuraSkill)SpiritualMagics.DARKNESS.get());
            listLearn.add((TensuraSkill)SpiritualMagics.DARK_CUBE.get());
            listLearn.add((TensuraSkill)SpiritualMagics.SHADOW_BIND.get());
            listLearn.add((TensuraSkill)SpiritualMagics.DARKNESS_CANNON.get());
            listLearn.add((TensuraSkill)SpiritualMagics.TRUE_DARKNESS.get());
        }
        listLearn.forEach(skill -> SkillAPI.getSkillsFrom((Entity)player).learnSkill((ManasSkill)skill));
    }
}

