/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.item.weapon;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.Memoires.trmysticism.api.ICanAttack;
import io.github.Memoires.trmysticism.entity.projectile.skill.AntiMaterialBulletProjectile;
import io.github.Memoires.trmysticism.registry.items.MysticismWeaponItems;
import io.github.Memoires.trmysticism.registry.materials.MysticismMaterials;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trmysticism")
public class AntiMaterialSniperRifleItem
extends TieredItem
implements Vanishable,
ICanAttack {
    private static final int RELOAD_TIME = 60;
    private static final int PENALTY_COOLDOWN = 200;
    private static final int MARGIN_OF_ERROR = 10;
    private static final double ZOOM_SPEED = 0.025;
    private static double zoomFOV = 1.0;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private long reloadTimestamp = 0L;
    private Vec3 heldPos = null;

    public AntiMaterialSniperRifleItem() {
        super(MysticismMaterials.ANTI_MATERIAL, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41497_(Rarity.EPIC));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)MysticismMaterials.ANTI_MATERIAL.m_6631_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)MysticismMaterials.ANTI_MATERIAL.m_6624_(), AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!(pEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)pEntity;
        if (pLevel.m_46467_() > this.reloadTimestamp + 10L && !living.getPersistentData().m_128471_("loaded")) {
            living.getPersistentData().m_128379_("loaded", true);
            if (living instanceof Player) {
                player = (Player)living;
                player.m_36335_().m_41524_((Item)MysticismWeaponItems.ANTI_MATERIAL_SNIPER_RIFLE.get(), 200);
            }
        }
        if (living.getPersistentData().m_128471_("isZooming") && !living.m_21055_((Item)this)) {
            this.m_5551_(pStack, pLevel, living, 0);
            return;
        }
        if (living.m_20184_().f_82480_ >= -living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) && living.m_21055_((Item)this)) {
            if (this.heldPos == null) {
                this.heldPos = living.m_20182_();
            }
            if (pEntity instanceof ServerPlayer) {
                player = (ServerPlayer)pEntity;
                HashSet<ClientboundPlayerPositionPacket.RelativeArgument> flags = new HashSet<ClientboundPlayerPositionPacket.RelativeArgument>(Set.of(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT, ClientboundPlayerPositionPacket.RelativeArgument.X_ROT));
                player.f_8906_.m_9780_(this.heldPos.f_82479_, this.heldPos.f_82480_, this.heldPos.f_82481_, player.m_146908_(), player.m_146909_(), flags);
            } else {
                pEntity.m_6027_(this.heldPos.f_82479_, this.heldPos.f_82480_, this.heldPos.f_82481_);
            }
        } else if (this.heldPos != null) {
            this.heldPos = null;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.m_46467_() <= this.reloadTimestamp + 10L) {
            pPlayer.getPersistentData().m_128379_("loaded", true);
            pPlayer.getPersistentData().m_128379_("perfectReload", true);
        }
        pPlayer.getPersistentData().m_128379_("isZooming", true);
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        pLivingEntity.getPersistentData().m_128379_("isZooming", false);
    }

    public int m_8105_(ItemStack pStack) {
        return Integer.MAX_VALUE;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public void attack(ItemStack pStack, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (player.m_36335_().m_41519_((Item)this)) {
                return;
            }
            this.reloadTimestamp = pLivingEntity.f_19853_.m_46467_() + 60L;
            pLivingEntity.getPersistentData().m_128379_("loaded", false);
            player.m_36335_().m_41524_((Item)MysticismWeaponItems.ANTI_MATERIAL_SNIPER_RIFLE.get(), 60);
        }
        if (!pLivingEntity.getPersistentData().m_128471_("isZooming")) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)pLivingEntity);
        Optional instance = storage.getSkill((ManasSkill)UltimateSkills.HERACLES.get());
        if (instance.isPresent()) {
            ManasSkillInstance skill = (ManasSkillInstance)instance.get();
            AntiMaterialBulletProjectile bullet = new AntiMaterialBulletProjectile(pLivingEntity);
            if (pLivingEntity.getPersistentData().m_128471_("perfectReload")) {
                bullet.setDamage(bullet.getDamage() * 1.5f);
            }
            if (pLivingEntity.f_19853_.m_213780_().m_188500_() < 0.25) {
                bullet.setDamage(bullet.getDamage() * 3.0f);
            }
            bullet.setSpeed(50.0f);
            bullet.setExplosionRadius(4.0f);
            bullet.setSkill(skill);
            bullet.setPosAndShoot(pLivingEntity);
            pLivingEntity.f_19853_.m_7967_((Entity)bullet);
            pLivingEntity.m_21011_(InteractionHand.MAIN_HAND, true);
            pLivingEntity.getPersistentData().m_128379_("perfectReload", false);
            this.m_5551_(pStack, pLivingEntity.f_19853_, pLivingEntity, 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFOVUpdate(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        double targetZoom = 0.5;
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        Optional instance = storage.getSkill((ManasSkill)UltimateSkills.HERACLES.get());
        if (instance.isPresent()) {
            targetZoom = ((ManasSkillInstance)instance.get()).getOrCreateTag().m_128459_("range");
        }
        if (player.getPersistentData().m_128471_("isZooming")) {
            if (zoomFOV > targetZoom) {
                zoomFOV -= 0.025;
            } else if (zoomFOV < targetZoom) {
                zoomFOV += 0.025;
            }
        } else if (zoomFOV < 1.0) {
            zoomFOV += 0.025;
        } else if (zoomFOV > 1.0) {
            zoomFOV = 1.0;
        }
        event.setFOV(event.getFOV() * zoomFOV);
    }
}

