/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.item.weapon;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.SimpleScytheItem;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import io.github.Memoires.trmysticism.item.client.RitualScytheRenderer;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class RitualScytheItem
extends SimpleScytheItem
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public RitualScytheItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, 13, -3.0f, 2.0, 20.0, 0.0, 3, -3.2f, 100.0, 50.0, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41499_(2000));
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity pEntity) {
        if (this.shouldVanish(pEntity)) {
            itemstack.m_41622_(itemstack.m_41776_(), pEntity, entity -> entity.m_21190_(pEntity.m_7655_()));
            return false;
        }
        return super.onEntitySwing(itemstack, pEntity);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.f_19853_.f_46443_ && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            float cooldown = player.m_36403_(0.5f);
            if (player.m_21206_().m_41619_()) {
                if (cooldown >= 1.0f) {
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)player, (float)RitualScytheItem.calculateSHPDamage(player));
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                } else {
                    DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)player, (float)(RitualScytheItem.calculateSHPDamage(player) / 10.0f));
                    player.m_21011_(InteractionHand.MAIN_HAND, true);
                }
            } else if (cooldown >= 1.0f) {
                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)player, (float)RitualScytheItem.calculateSHPDamage(player));
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
            } else {
                DamageSourceHelper.directSpiritualHurt((LivingEntity)target, (Entity)player, (float)(RitualScytheItem.calculateSHPDamage(player) / 10.0f));
                player.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }
        return true;
    }

    public static float calculateSHPDamage(Player player) {
        int soulPoints = TensuraPlayerCapability.getSoulPoints((Player)player);
        float progress = Mth.m_14036_((float)((float)soulPoints / 5000000.0f), (float)0.0f, (float)1.0f);
        return 30.0f + progress * 1470.0f;
    }

    private boolean shouldVanish(LivingEntity pEntity) {
        Optional optional = SkillAPI.getSkillsFrom((Entity)pEntity).getSkill((ManasSkill)UniqueSkills.SPIRITUALIST.get());
        if (optional.isPresent() && ((ManasSkillInstance)optional.get()).getSkill().canInteractSkill((ManasSkillInstance)optional.get(), pEntity)) {
            return false;
        }
        if (pEntity instanceof Player) {
            Player pPlayer = (Player)pEntity;
            return !pPlayer.m_7500_();
        }
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final RitualScytheRenderer renderer = new RitualScytheRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public double getSweepChance() {
        return 0.0;
    }
}

