/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.menu;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import io.github.Memoires.trmysticism.api.IWeaponStorage;
import io.github.Memoires.trmysticism.menu.container.WeaponStorageContainer;
import io.github.Memoires.trmysticism.menu.slot.WeaponSlot;
import io.github.Memoires.trmysticism.registry.skill.UniqueSkills;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WeaponStorageMenu
extends AbstractContainerMenu {
    private static final Logger log = LogManager.getLogger(WeaponStorageMenu.class);
    private final ManasSkill skill;
    private final Player player;
    private final SimpleContainer container;
    private final DataSlot startIndex = DataSlot.m_39401_();

    public WeaponStorageMenu(int id, Inventory inv, Player player, SimpleContainer container, ManasSkill skill) {
        super((MenuType)null, id);
        this.skill = skill;
        this.player = player;
        this.container = container;
        boolean isMastered = ((ManasSkillInstance)SkillAPI.getSkillsFrom((Entity)player).getSkill((ManasSkill)UniqueSkills.GATEKEEPER.get()).get()).isMastered((LivingEntity)player);
        this.container.m_19164_(arg_0 -> ((WeaponStorageMenu)this).m_6199_(arg_0));
        WeaponStorageMenu.m_38869_((Container)container, (int)(isMastered ? 10 : 5));
        this.m_38895_(this.startIndex).m_6422_(0);
        container.m_5856_(player);
        this.addSpatialSlots(isMastered);
        this.addPlayerInventory(inv);
        this.addPlayerHotBar(inv);
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        if (this.isValidRecipeIndex(pId)) {
            this.startIndex.m_6422_(pId);
            this.container.m_6596_();
            this.m_6199_((Container)this.container);
            this.f_38839_.forEach(Slot::m_6654_);
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.getStorageSize();
    }

    public int getStartIndex() {
        return this.startIndex.m_6501_();
    }

    public int getStorageSize() {
        return this.container.m_6643_();
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.m_38897_(new Slot((Container)inventory, slot + row * 9 + 9, 8 + slot * 18, 86 + row * 18));
            }
        }
    }

    private void addPlayerHotBar(Inventory inventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 144));
        }
    }

    private void addSpatialSlots(boolean isMastered) {
        int rows = isMastered ? 2 : 1;
        int slotsPerRow = 5;
        for (int j = 0; j < rows; ++j) {
            for (int k = 0; k < slotsPerRow; ++k) {
                this.m_38897_(new WeaponSlot(this, (Container)this.container, k + j * slotsPerRow, 44 + k * 18, 19 + j * 18));
            }
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    @Nullable
    private ManasSkillInstance getSkillInstance(Player player) {
        Optional optional = SkillAPI.getSkillsFrom((Entity)player).getSkill(this.skill);
        return optional.orElse(null);
    }

    public void m_6877_(Player pPlayer) {
        SimpleContainer var5;
        ManasSkillInstance instance = this.getSkillInstance(pPlayer);
        if (instance != null && (var5 = this.container) instanceof WeaponStorageContainer) {
            WeaponStorageContainer storageContainer = (WeaponStorageContainer)var5;
            ManasSkill var6 = instance.getSkill();
            if (var6 instanceof IWeaponStorage) {
                IWeaponStorage spatialStorage = (IWeaponStorage)var6;
                spatialStorage.saveContainer(instance, (LivingEntity)pPlayer, storageContainer);
            }
        }
        super.m_6877_(pPlayer);
        this.container.m_5785_(pPlayer);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex < 31 ? !this.m_38903_(itemstack1, 31, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 31, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.m_41753_()) {
            while (!pStack.m_41619_() && !(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && slot.m_5857_(pStack) && ItemStack.m_150942_((ItemStack)pStack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + pStack.m_41613_();
                    int n = maxSize = i < 27 ? this.container.m_6893_() : Math.min(itemstack.m_41741_(), slot.m_6641_());
                    if (j <= maxSize) {
                        pStack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        pStack.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.m_41619_()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot pSlot = (Slot)this.f_38839_.get(i);
                ItemStack stack = pSlot.m_7993_();
                if (stack.m_41619_() && pSlot.m_5857_(pStack)) {
                    if (pStack.m_41613_() > pSlot.m_6641_()) {
                        pSlot.m_5852_(pStack.m_41620_(pSlot.m_6641_()));
                    } else {
                        pSlot.m_5852_(pStack.m_41620_(pStack.m_41613_()));
                    }
                    pSlot.m_6654_();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ManasSkill getSkill() {
        return this.skill;
    }

    public Player getPlayer() {
        return this.player;
    }
}

