/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.DisintegrationEntity;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import java.lang.reflect.Method;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DisintegrationEntity.class})
public class MixinDisintegration {
    private static boolean hasUriel(LivingEntity living) {
        return TensuraSkillCapability.isSkillInSlot((LivingEntity)living, (ManasSkill)((ManasSkill)UltimateSkills.URIEL.get()));
    }

    @Inject(method={"getDisintegrationDamage"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getDisintegrationDamage(Entity entity, CallbackInfoReturnable<DamageSource> cir) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && MixinDisintegration.hasUriel(livingEntity = (LivingEntity)entity)) {
            DamageSource source = entity == null ? TensuraDamageSources.lightning((Entity)entity) : TensuraDamageSources.lightning((Entity)entity);
            cir.setReturnValue((Object)new DamageSource("no_damage").m_19382_());
        } else {
            DamageSource source = entity == null ? TensuraDamageSources.HOLY_DAMAGE : TensuraDamageSources.holyDamage((Entity)entity);
            cir.setReturnValue((Object)DamageSourceHelper.turnTensura((DamageSource)source).setNoKnock().setIgnoreBarrier(3.0f).m_238403_().m_19382_().m_19381_());
        }
    }

    @Inject(method={"hitTarget"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onHitTarget(CallbackInfo ci) {
        DisintegrationEntity entity = (DisintegrationEntity)this;
        float amount = 100.0f;
        AABB affectedArea = null;
        try {
            Method getAffectedAreaMethod = BarrierEntity.class.getDeclaredMethod("getAffectedArea", new Class[0]);
            getAffectedAreaMethod.setAccessible(true);
            affectedArea = (AABB)getAffectedAreaMethod.invoke((Object)entity, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (affectedArea != null) {
            for (LivingEntity livingEntity : entity.m_9236_().m_45976_(LivingEntity.class, affectedArea)) {
                double cost;
                if (!MixinDisintegration.hasUriel(livingEntity) || !(livingEntity instanceof Player)) continue;
                Player player = (Player)livingEntity;
                amount = 10.0f;
                double maxMP = TensuraPlayerCapability.getBaseMagicule((Player)player);
                if (!(maxMP > (cost = maxMP * 0.01))) continue;
                TensuraPlayerCapability.decreaseMagicule((Player)player, (double)cost);
                ci.cancel();
                return;
            }
            for (ItemEntity item : entity.m_9236_().m_45976_(ItemEntity.class, affectedArea)) {
                item.m_6469_(TensuraDamageSources.HOLY_DAMAGE, amount);
            }
        }
    }
}

