/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.api.magicule.MagiculeAPI;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.handler.OnTickHandler;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import io.github.Memoires.trmysticism.race.angel.LesserAngelRace;
import io.github.Memoires.trmysticism.race.elemental.LesserSpiritRace;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={OnTickHandler.class})
public class MixinOnTick {
    @Inject(method={"energyRegen"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void addElementalRealmCheck(LivingEntity entity, CallbackInfo ci) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TensuraPlayerCapability.getFrom((Player)player).ifPresent(cap -> {
                if (cap.getRace() != null) {
                    if (player.m_150110_().f_35934_ || !(cap.getAura() < 0.0) && !(cap.getMagicule() < 0.0)) {
                        boolean shouldSync = false;
                        if (cap.getSleepMode() > 0) {
                            cap.setSleepMode(cap.getSleepMode() - 1);
                            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.SLEEP_MODE.get(), 20, 0, false, false, false));
                            shouldSync = true;
                        } else if (player.m_21023_((MobEffect)TensuraMobEffects.SLEEP_MODE.get())) {
                            player.m_21195_((MobEffect)TensuraMobEffects.SLEEP_MODE.get());
                        }
                        if (cap.getMagicule() <= 0.0) {
                            cap.setSleepMode(20);
                            if (cap.getMagicule() < 0.0) {
                                player.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, player.m_21233_() * 10.0f);
                                return;
                            }
                        }
                        double maxAura = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_AURA.get());
                        double maxMagicule = player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_MAGICULE.get());
                        int difference = (int)(MagiculeAPI.getMagicule((LivingEntity)player) / ((maxMagicule + maxAura) * 4.0));
                        if (!(difference <= MixinOnTick.getMagiculePoisonResistance((Player)player) || player.m_5833_() || player.m_7500_() || player.m_9236_().m_46472_() == TensuraDimensions.HELL && cap.getRace().getRespawnDimension() == TensuraDimensions.HELL)) {
                            player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGICULE_POISON.get(), 100, difference - 1, false, false));
                        }
                        if (cap.isSpiritualForm() && !player.m_7500_() && !player.m_5833_() && player.m_9236_().m_46472_() != TensuraDimensions.HELL && player.m_9236_().m_46472_() != TensuraDimensions.LABYRINTH && player.m_9236_().m_46472_() != MysticismDimensions.ELEMENTAL_REALM) {
                            cap.setMagicule(Math.max(cap.getMagicule() - 115.0, -1.0));
                            shouldSync = true;
                        } else {
                            double mana = MagiculeAPI.getMagicule((LivingEntity)player) * (Double)TensuraConfig.INSTANCE.magiculeConfig.manaRegen.get();
                            if (cap.getMagicule() > maxMagicule) {
                                if (cap.getMagicule() > maxMagicule * 1.25) {
                                    double extraMP = cap.getMagicule() - maxMagicule * 1.25;
                                    int poisonLevel = (int)(extraMP / (maxMagicule * 0.25));
                                    player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.MAGICULE_POISON.get(), 100, poisonLevel, false, false));
                                }
                                cap.setMagicule(Math.max(cap.getMagicule() - (Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get(), maxMagicule));
                                shouldSync = true;
                            } else if (cap.getMagicule() < maxMagicule) {
                                double newMana = cap.getMagicule() + SkillHelper.mpRegen((LivingEntity)player, (double)maxMagicule, (double)mana);
                                cap.setMagicule(Math.min(newMana, maxMagicule));
                                shouldSync = true;
                            }
                        }
                        if (cap.getAura() <= 0.0) {
                            MixinOnTick.auraPenalties((Player)player);
                        }
                        if (cap.getAura() < maxAura) {
                            double newAura = cap.getAura() + SkillHelper.apRegen((LivingEntity)player, (double)maxAura, (double)((Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get()));
                            cap.setAura(Math.min(newAura, maxAura));
                            shouldSync = true;
                        } else if (cap.getAura() > maxAura) {
                            if (cap.getAura() > maxAura * 1.25) {
                                double extraAP = cap.getAura() - maxAura * 1.25;
                                int insaneLevel = 1 + 2 * (int)(extraAP / (maxAura * 0.25));
                                player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 100, insaneLevel, false, false));
                            }
                            cap.setAura(Math.max(cap.getAura() - (Double)TensuraConfig.INSTANCE.magiculeConfig.auraRegen.get(), maxAura));
                            shouldSync = true;
                        }
                        if (shouldSync) {
                            TensuraPlayerCapability.sync((Player)player);
                        }
                    } else {
                        player.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, player.m_21233_());
                    }
                }
            });
        } else {
            TensuraEPCapability.getFrom((LivingEntity)entity).ifPresent(cap -> {
                if (!(cap.getEP() < 0.0) && !(cap.getCurrentEP() < 0.0)) {
                    if (cap.getCurrentEP() < cap.getEP()) {
                        double mana = SkillHelper.mpRegen((LivingEntity)entity, (double)cap.getEP(), (double)(MagiculeAPI.getMagicule((LivingEntity)entity) * 0.01));
                        double newEP = cap.getCurrentEP() + SkillHelper.apRegen((LivingEntity)entity, (double)cap.getEP(), (double)2.0) + mana;
                        cap.setCurrentEP(entity, Math.min(newEP, cap.getEP()));
                    }
                } else {
                    entity.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, entity.m_21233_() * 10.0f);
                }
            });
        }
        ci.cancel();
    }

    private static int getMagiculePoisonResistance(Player player) {
        Race playerRace;
        int level = 0;
        if (TensuraEPCapability.isMajin((LivingEntity)player)) {
            ++level;
        }
        if ((playerRace = TensuraPlayerCapability.getRace((LivingEntity)player)) instanceof LesserSpiritRace || playerRace instanceof LesserAngelRace) {
            level += 10;
        }
        if (SkillUtils.isSkillToggled((Entity)player, (ManasSkill)((ManasSkill)ResistanceSkills.MAGIC_RESISTANCE.get()))) {
            level += 2;
        }
        return level;
    }

    private static void auraPenalties(Player player) {
        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2, false, false));
    }
}

