/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin;

import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TensuraSkillCapability.class})
public class MixinTensuraSkillCapability {
    @Inject(method={"resetEverything"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void resetCurrentUltimates(Player player, boolean clearWarp, boolean spirit, CallbackInfo ci) {
        if (clearWarp) {
            MysticismPlayerCapability.getFrom(player).ifPresent(cap -> cap.setCurrentUltimates(0));
        }
        if (spirit) {
            MysticismPlayerCapability.getFrom(player).ifPresent(cap -> cap.setLightningStrikes(0));
        }
    }

    @Inject(method={"setSpiritLevel"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void onSetSpiritLevel(Player player, int spirit, int level, CallbackInfoReturnable<Boolean> cir) {
        if (level == 0) {
            try {
                Field spiritLevelsField = TensuraSkillCapability.class.getDeclaredField("spiritLevels");
                spiritLevelsField.setAccessible(true);
                List spiritLevels = (List)spiritLevelsField.get(this);
                if (spirit >= 0 && spirit < spiritLevels.size()) {
                    spiritLevels.set(spirit, 0);
                    cir.setReturnValue((Object)true);
                    cir.cancel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

