/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin.abilities.skills;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.unique.LustSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.DirewolfEntity;
import com.github.manasmods.tensura.entity.SissieEntity;
import com.github.manasmods.tensura.entity.multipart.EvilCentipedeBody;
import com.github.manasmods.tensura.entity.multipart.TempestSerpentBody;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import io.github.Memoires.trmysticism.entity.skill.LingeringSoulEntity;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LustSkill.class})
public class MixinLustSkill
extends Skill {
    public MixinLustSkill(Skill.SkillType type) {
        super(type);
    }

    @Inject(method={"onPressed"}, at={@At(value="HEAD")}, remap=false)
    public void onPressed(ManasSkillInstance instance, LivingEntity entity, CallbackInfo ci) {
        if (instance.getMode() == 3) {
            LingeringSoulEntity soul = (LingeringSoulEntity)SkillHelper.getTargetingEntity(LingeringSoulEntity.class, (LivingEntity)entity, (double)20.0, (double)0.0, (boolean)true);
            if (soul == null || !soul.m_6084_() || !soul.hasOriginalMobData()) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.no_valid_soul").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                }
                return;
            }
            this.tensura_Mysticism$reviveSubordinate(instance, soul, (Player)entity);
            instance.addMasteryPoint(entity);
        }
    }

    public boolean canBeToggled(ManasSkillInstance instance, @NotNull LivingEntity entity) {
        return instance.getMastery() >= 0;
    }

    public void onSubordinateDeath(ManasSkillInstance instance, @NotNull LivingEntity owner, @NotNull LivingDeathEvent e) {
        if (!instance.isToggled()) {
            return;
        }
        LivingEntity originalEntity = e.getEntity();
        if (originalEntity.getPersistentData().m_128471_("is_display")) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.mephisto.life_domination.message.is_display").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            return;
        }
        if (!(originalEntity instanceof Mob)) {
            return;
        }
        if (originalEntity.m_20270_((Entity)owner) > 30.0f) {
            return;
        }
        Level level = owner.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                LingeringSoulEntity soul = new LingeringSoulEntity(level, originalEntity.m_20183_());
                soul.setOriginalMobData(originalEntity);
                soul.m_20084_(UUID.randomUUID());
                if (!serverLevel.m_7967_((Entity)soul)) {
                    throw new RuntimeException("Failed to add LingeringSoulEntity to the server");
                }
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.lingering_soul_spawned", (Object[])new Object[]{originalEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE)), false);
                }
            }
            catch (Exception ex) {
                System.err.println("Error spawning LingeringSoulEntity: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Unique
    private void tensura_Mysticism$reviveSubordinate(ManasSkillInstance instance, LingeringSoulEntity soul, Player owner) {
        if (soul == null || !soul.m_6084_()) {
            return;
        }
        if (!soul.hasOriginalMobData()) {
            System.out.println("LingeringSoulEntity has no original mob data.");
            return;
        }
        Level level = soul.m_9236_();
        CompoundTag mobData = soul.getOriginalMobData();
        if (!mobData.m_128441_("id")) {
            System.out.println("Missing 'id' in mobData: " + mobData);
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.invalid_data").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        LivingEntity dummyEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (dummyEntity == null) {
            System.out.println("Failed to load dummy entity for EP calculation.");
            return;
        }
        double magiculeCost = TensuraEPCapability.getEP((LivingEntity)dummyEntity);
        double currentMagicule = TensuraPlayerCapability.getMagicule((Player)owner);
        if (currentMagicule < magiculeCost) {
            owner.m_5661_((Component)Component.m_237115_((String)"trmysticism.skill.mode.sephirot.life_domination.not_enough_magicule").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            return;
        }
        TensuraPlayerCapability.setMagicule((Player)owner, (double)(currentMagicule - magiculeCost));
        TensuraPlayerCapability.sync((Player)owner);
        LivingEntity revivedEntity = (LivingEntity)EntityType.m_20645_((CompoundTag)mobData, (Level)level, entity -> entity);
        if (revivedEntity != null) {
            revivedEntity.m_21153_(revivedEntity.m_21233_() / 10.0f);
            level.m_5594_(null, revivedEntity.m_20183_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 2.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)revivedEntity, (ParticleOptions)ParticleTypes.f_123767_, (double)2.0);
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
            revivedEntity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 3));
            this.tensura_Mysticism$clearInventory(revivedEntity);
            level.m_7967_((Entity)revivedEntity);
            if (instance.isMastered((LivingEntity)owner)) {
                instance.setCoolDown(20);
            } else {
                instance.setCoolDown(60);
            }
            if (!level.m_5776_()) {
                soul.m_146870_();
            }
            owner.m_5661_((Component)Component.m_237110_((String)"trmysticism.skill.mode.sephirot.life_domination.subordinate_revived", (Object[])new Object[]{revivedEntity.m_7755_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), false);
        } else {
            System.out.println("Failed to revive entity from mobData: " + mobData);
        }
    }

    @Unique
    private void tensura_Mysticism$clearInventory(LivingEntity revivedEntity) {
        if (revivedEntity instanceof HumanoidNPCEntity) {
            HumanoidNPCEntity humanoidNPCEntity = (HumanoidNPCEntity)revivedEntity;
            humanoidNPCEntity.inventory.m_6211_();
        } else if (revivedEntity instanceof DirewolfEntity) {
            DirewolfEntity direwolf = (DirewolfEntity)revivedEntity;
            direwolf.inventory.m_6211_();
        } else if (revivedEntity instanceof SissieEntity) {
            SissieEntity sissie = (SissieEntity)revivedEntity;
            sissie.inventory.m_6211_();
        } else if (revivedEntity instanceof EvilCentipedeBody) {
            EvilCentipedeBody evilCentipede = (EvilCentipedeBody)revivedEntity;
            evilCentipede.inventory.m_6211_();
        } else if (revivedEntity instanceof TempestSerpentBody) {
            TempestSerpentBody tempestSerpent = (TempestSerpentBody)revivedEntity;
            tempestSerpent.inventory.m_6211_();
        }
        revivedEntity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        revivedEntity.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_41852_, 100));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            revivedEntity.m_8061_(slot, ItemStack.f_41583_);
        }
    }
}

