/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin.abilities.skills;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.intrinsic.PossessionSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import io.github.Memoires.trmysticism.entity.OkamiEntity;
import io.github.Memoires.trmysticism.entity.golems.LowMagisteelGolemEntity;
import io.github.Memoires.trmysticism.race.daemonDoll.GreaterDollRace;
import io.github.Memoires.trmysticism.race.tengu.TenguRace;
import io.github.Memoires.trmysticism.registry.dimensions.MysticismDimensions;
import io.github.Memoires.trmysticism.registry.skill.UltimateSkills;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PossessionSkill.class})
public abstract class MixinPossessionSkill {
    @Inject(method={"canPossess"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void addTsukuyomiPossessionCheck(LivingEntity target, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)((ManasSkill)UltimateSkills.TSUKUYOMI.get()))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"copyStatsAndSkills"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preventModification(LivingEntity target, Player owner, CallbackInfo ci) {
        if (target instanceof OkamiEntity && this.tensura_Mysticism$isAngelRace((LivingEntity)owner) || target instanceof LowMagisteelGolemEntity && this.tensura_Mysticism$isDemonRace((LivingEntity)owner)) {
            ci.cancel();
        }
    }

    @Inject(method={"applyBaseAttributeModifiers"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void preventModificationAttr(LivingEntity owner, LivingEntity target, CallbackInfo ci) {
        if (target.getClass() == OkamiEntity.class && this.tensura_Mysticism$isAngelRace(owner)) {
            ci.cancel();
        }
        if (target instanceof LowMagisteelGolemEntity && this.tensura_Mysticism$isDemonRace(owner)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean tensura_Mysticism$isAngelRace(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            assert (race != null);
            return race.getClass() == TenguRace.class;
        }
        return false;
    }

    @Unique
    private boolean tensura_Mysticism$isDemonRace(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
            return race instanceof GreaterDollRace;
        }
        return false;
    }

    @Inject(method={"onPressed"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void injectDungeonPossessionCheck(ManasSkillInstance instance, LivingEntity owner, CallbackInfo ci) {
        Level level = owner.m_9236_();
        if (level.m_46472_().equals(MysticismDimensions.ELEMENTAL_REALM)) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237115_((String)"tensura.ability.activation_failed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
            }
            ci.cancel();
        }
    }
}

