/*
 * Decompiled with CFR 0.152.
 */
package io.github.Memoires.trmysticism.mixin.buffStack;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.skill.extra.WaterManipulationSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.Memoires.trmysticism.capability.race.MysticismPlayerCapability;
import io.github.Memoires.trmysticism.race.elemental.ElementalQueenRace;
import io.github.Memoires.trmysticism.race.elemental.GreaterSpiritRace;
import io.github.Memoires.trmysticism.race.elemental.LesserSpiritRace;
import io.github.Memoires.trmysticism.race.elemental.MediumSpiritRace;
import io.github.Memoires.trmysticism.race.elemental.SpiritLordRace;
import io.github.Memoires.trmysticism.registry.skill.ExtraSkills;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WaterManipulationSkill.class})
public class MixinWaterManipulationSkill {
    @Unique
    private static final Set<Class<?>> SPIRIT_RACES = Set.of(LesserSpiritRace.class, MediumSpiritRace.class, GreaterSpiritRace.class, SpiritLordRace.class, ElementalQueenRace.class);

    @Inject(at={@At(value="HEAD")}, remap=false, cancellable=true, method={"onDamageEntity"})
    private void damageEntity(ManasSkillInstance instance, LivingEntity living, LivingHurtEvent e, CallbackInfo ci) {
        if (instance.isToggled() && SkillUtils.isSkillToggled((Entity)living, (ManasSkill)((ManasSkill)ExtraSkills.WATER_AND_THUNDER_DOMINATION.get()))) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"hasWater"}, remap=false)
    private static boolean canUseFire(boolean original, LivingEntity entity) {
        Race race = TensuraPlayerCapability.getRace((LivingEntity)entity);
        if (race != null && SPIRIT_RACES.stream().anyMatch(r -> r.isInstance(race)) && MysticismPlayerCapability.getElement((Player)entity) == MagicElemental.WATER) {
            original = true;
        }
        return original;
    }
}

